/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.google.common.base.MoreObjects;
import com.simsilica.mod.ModInfo;
import com.simsilica.mod.ModManager;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModPack {
    static Logger log = LoggerFactory.getLogger(ModPack.class);
    private URI root;
    private ModInfo info;
    private GroovyScriptEngine scriptEngine;
    private ModManager manager;
    private List<Runnable> terminateCallbacks = new ArrayList<Runnable>();
    private boolean initializing = false;
    private boolean enabled;

    public ModPack(URI root, ModInfo info) {
        this.root = root;
        this.info = info;
        this.enabled = info.isEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected ModManager getModManager() {
        return this.manager;
    }

    public void initialize(ModManager manager) {
        this.manager = manager;
        try {
            CompilerConfiguration config = manager.getCompilerConfig();
            this.scriptEngine = new GroovyScriptEngine(new URL[]{this.root.toURL()});
            this.scriptEngine.setConfig(config);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error resolving root to URL:" + this.root, e);
        }
        this.initializing = true;
        LocalBinding binding = new LocalBinding(this.info.getGroupId() + "." + this.info.getName(), manager.getGlobalBindings());
        for (String s : this.info.getInitScripts()) {
            log.info("Running:" + s);
            try {
                this.scriptEngine.run(s, (Binding)binding);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running:" + s, e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("post bindings:" + manager.getGlobalBindings());
        }
        this.initializing = false;
    }

    public void terminate() {
        for (Runnable callback : this.terminateCallbacks) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Running terminate callback:" + callback);
                }
                callback.run();
            }
            catch (Exception e) {
                throw new RuntimeException("Error running termination callback:" + callback, e);
            }
        }
        this.terminateCallbacks.clear();
        LocalBinding binding = new LocalBinding(this.info.getGroupId() + "." + this.info.getName(), this.manager.getGlobalBindings());
        for (String s : this.info.getTerminateScripts()) {
            log.info("Running:" + s);
            try {
                this.scriptEngine.run(s, (Binding)binding);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running:" + s, e);
            }
        }
    }

    public String getId() {
        return this.info.getId();
    }

    public URI getRoot() {
        return this.root;
    }

    public URI getResource(String resource) {
        if (!this.info.getResources().contains(resource)) {
            throw new IllegalArgumentException("Resource not configured:" + resource);
        }
        return this.root.resolve(resource);
    }

    public List<String> getDependencies() {
        return this.info.getDependencies();
    }

    public ModInfo getInfo() {
        return this.info;
    }

    public Map<String, Object> getConfig() {
        return this.info.getConfig();
    }

    public void onTerminate(Runnable callback) {
        this.terminateCallbacks.add(callback);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("root", (Object)this.root).add("info", (Object)this.info).toString();
    }

    private class LocalBinding
    extends Binding {
        private Logger log;

        public LocalBinding(String context, Map<String, Object> map) {
            super(map);
            this.log = LoggerFactory.getLogger((String)context);
        }

        public ModPack getMod() {
            return ModPack.this;
        }

        public void setVariable(String name, Object value) {
            if ("mod".equals(name)) {
                throw new IllegalArgumentException("The 'mod' binding is hard-wired.");
            }
            if ("log".equals(name)) {
                throw new IllegalArgumentException("The 'log' binding is hard-wired.");
            }
            if (!ModPack.this.initializing) {
                this.log.warn("Setting binding outside of init:" + name + "=" + value, new Throwable("stack-trace"));
            }
            super.setVariable(name, value);
        }

        public Object getProperty(String property) {
            if ("mod".equals(property)) {
                return this.getMod();
            }
            if ("log".equals(property)) {
                return this.log;
            }
            return super.getProperty(property);
        }

        public Object getVariable(String name) {
            if ("mod".equals(name)) {
                return this.getMod();
            }
            if ("log".equals(name)) {
                return this.log;
            }
            return super.getVariable(name);
        }

        public boolean hasVariable(String name) {
            if ("mod".equals(name)) {
                return true;
            }
            if ("log".equals(name)) {
                return true;
            }
            return super.hasVariable(name);
        }
    }
}

