/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.PanelTweens;
import com.simsilica.lemur.anim.SpatialTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.lemur.effect.AbstractEffect;
import com.simsilica.lemur.effect.Effect;
import com.simsilica.lemur.effect.EffectInfo;
import com.simsilica.lemur.style.ElementId;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CreditsState.class);
    private Node creditsRoot;
    private float fadeTime = 2.0f;
    private List<Credit> credits = new ArrayList<Credit>();
    private Credit current = null;
    private float time;

    public void setFadeTime(float fadeTime) {
        this.fadeTime = fadeTime;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void addCredit(String message, double start, double end, double xPercent, double yPercent) {
        Label label = new Label(message, new ElementId("credits.label"));
        Credit credit = new Credit(label, start, end - (double)this.fadeTime, xPercent, yPercent);
        this.credits.add(credit);
        if (this.isInitialized()) {
            credit.setup();
        }
    }

    protected void initialize(Application app) {
        this.creditsRoot = new Node("creditsRoot");
        for (Credit c : this.credits) {
            c.setup();
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.creditsRoot);
        this.time = 0.0f;
    }

    protected void onDisable() {
        this.creditsRoot.removeFromParent();
    }

    public void update(float tpf) {
        this.time += tpf;
        this.updateCurrent();
        if (this.current != null) {
            this.current.update(this.time);
        }
    }

    protected void updateCurrent() {
        if (this.current != null && (double)this.time < this.current.end) {
            return;
        }
        if (this.current != null) {
            this.current.stop();
        }
        this.current = null;
        for (Credit credit : this.credits) {
            if ((double)this.time > credit.end) continue;
            this.current = credit;
            break;
        }
        log.info("current after loop:" + this.current);
        if (this.current == null) {
            this.time = 0.0f;
        }
    }

    private class Credit {
        private Label label;
        private double start;
        private double end;
        private boolean running;
        private double xPercent;
        private double yPercent;

        public Credit(Label label, double start, double end, double xPercent, double yPercent) {
            this.label = label;
            this.start = start;
            this.end = end;
            this.xPercent = xPercent;
            this.yPercent = yPercent;
        }

        public void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            this.label.setAlpha(0.0f);
            this.label.setColor(this.label.getColor());
            this.label.runEffect("open");
        }

        public void stop() {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.label.runEffect("close");
        }

        public void update(float time) {
            if ((double)time >= this.start && (double)time < this.end) {
                this.start();
            } else if ((double)time >= this.end) {
                this.stop();
            }
        }

        protected void setup() {
            GuiState gui = (GuiState)CreditsState.this.getState(GuiState.class, true);
            float guiScale = gui.getStandardScale();
            Vector2f size = gui.getGuiSize();
            Vector3f pref = this.label.getPreferredSize();
            final Vector3f pos = new Vector3f((float)((double)size.x * this.xPercent), (float)((double)size.y * this.yPercent), 1000.0f);
            pos.x -= pref.x * 0.5f * guiScale;
            this.label.setLocalTranslation(0.0f, -600.0f, 0.0f);
            AbstractEffect<Panel> fadeIn = new AbstractEffect<Panel>("fade"){

                public Animation create(Panel target, EffectInfo existing) {
                    Tween attach = SpatialTweens.attach((Spatial)target, (Spatial)CreditsState.this.creditsRoot);
                    Tween delay = Tweens.delay((double)0.03333333333333333);
                    Tween fade = PanelTweens.fade((Panel)target, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f), (double)CreditsState.this.fadeTime);
                    Tween move = SpatialTweens.move((Spatial)target, (Vector3f)pos, (Vector3f)pos, (double)0.0);
                    return new TweenAnimation(new Tween[]{Tweens.parallel((Tween[])new Tween[]{attach, Tweens.sequence((Tween[])new Tween[]{delay, move, fade})})});
                }
            };
            AbstractEffect<Panel> fadeOut = new AbstractEffect<Panel>("fade"){

                public Animation create(Panel target, EffectInfo existing) {
                    Tween fade = PanelTweens.fade((Panel)target, (Float)Float.valueOf(1.0f), (Float)Float.valueOf(0.0f), (double)CreditsState.this.fadeTime);
                    Tween detach = SpatialTweens.detach((Spatial)target);
                    return new TweenAnimation(new Tween[]{fade, detach});
                }
            };
            this.label.addEffect("open", (Effect)fadeIn);
            this.label.addEffect("close", (Effect)fadeOut);
        }
    }
}

