/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import mythruna.client.ui.map.LineQuad;
import mythruna.client.ui.map.MapPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineWidget
extends Node {
    static Logger log = LoggerFactory.getLogger(LineWidget.class);
    private Vector2f clipRadius = new Vector2f();
    private MapPoint end1;
    private MapPoint end2;
    private Label label1;
    private Label label2;
    private Geometry geom;
    private LineQuad lineQuad;
    private Label lineLabel;
    private VersionedReference<MapPoint> end1Ref;
    private VersionedReference<MapPoint> end2Ref;

    public LineWidget(String name, MapPoint end1, MapPoint end2) {
        this(name, end1, end2, null);
    }

    public LineWidget(String name, MapPoint end1, MapPoint end2, AssetManager assets) {
        super(name);
        this.end1 = end1;
        this.end1Ref = end1.createReference();
        this.end2 = end2;
        this.end2Ref = end2.createReference();
        IconComponent icon = new IconComponent("Interface/gilded-crosshair-32.png");
        icon.setIconSize(new Vector2f(32.0f, 32.0f));
        icon.setHAlignment(HAlignment.Center);
        icon.setOverlay(true);
        this.label1 = new Label("");
        this.label1.setIcon((GuiComponent)icon.clone());
        this.label1.setSize(this.label1.getPreferredSize());
        this.label2 = new Label("");
        this.label2.setIcon((GuiComponent)icon);
        this.label2.setSize(this.label2.getPreferredSize());
        this.lineLabel = new Label("", new ElementId("map.line.label"));
        this.lineQuad = new LineQuad(new ColorRGBA(0.1f, 0.1f, 0.4f, 0.5f), 5.0f);
        this.geom = new Geometry(name + ":geom", this.lineQuad.getMesh());
        if (assets == null) {
            this.geom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.White, false).getMaterial());
            this.geom.getMaterial().setBoolean("VertexColor", true);
        } else {
            this.geom.setMaterial(new Material(assets, "MatDefs/LineQuad.j3md"));
            this.geom.getMaterial().setVector2("ClipRadius", this.clipRadius);
            this.geom.getMaterial().setColor("Color", ColorRGBA.White);
        }
        this.geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.attachChild((Spatial)this.label1);
        this.attachChild((Spatial)this.label2);
        this.attachChild((Spatial)this.geom);
        this.attachChild((Spatial)this.lineLabel);
        this.updateView();
    }

    public void setClipRadius(Vector2f clipRadius) {
        this.clipRadius.set(clipRadius);
        this.updateView();
    }

    public void setText(String text) {
        if (text == null) {
            this.lineLabel.setText("");
            this.lineLabel.removeFromParent();
        } else {
            this.lineLabel.setText(text);
            this.resetLabelPosition();
        }
    }

    public MapPoint getEnd1() {
        return this.end1;
    }

    public MapPoint getEnd2() {
        return this.end2;
    }

    public double getLength() {
        return this.end2.getWorld().distance(this.end1.getWorld());
    }

    public MapPoint findEnd(Spatial collision) {
        if (collision == null) {
            return null;
        }
        if (collision.hasAncestor((Node)this.label1)) {
            return this.end1;
        }
        if (collision.hasAncestor((Node)this.label2)) {
            return this.end2;
        }
        return null;
    }

    public void updateLogicalState(float tpf) {
        boolean changed = false;
        if (this.end1Ref.update()) {
            changed = true;
        }
        if (this.end2Ref.update()) {
            changed = true;
        }
        if (changed) {
            this.updateView();
        }
    }

    protected void centerLabel(Label label, Vector3f loc) {
        Vector3f size = label.getSize();
        label.setLocalTranslation(loc.x - size.x * 0.5f, loc.y + size.y * 0.5f, 20.0f);
    }

    protected boolean isClipped(Vector3f v) {
        log.info("isClipped(" + v + ", " + this.clipRadius + ")");
        if (this.clipRadius == null) {
            return false;
        }
        if (v.x < -this.clipRadius.x || v.x > this.clipRadius.x) {
            return true;
        }
        return v.y < -this.clipRadius.y || v.y > this.clipRadius.y;
    }

    protected void updateView() {
        Vector3f v1 = this.end1.getView();
        this.centerLabel(this.label1, v1);
        Vector3f v2 = this.end2.getView();
        this.centerLabel(this.label2, v2);
        if (this.isClipped(v1)) {
            this.label1.removeFromParent();
        } else {
            this.attachChild((Spatial)this.label1);
        }
        if (this.isClipped(v2)) {
            this.label2.removeFromParent();
        } else {
            this.attachChild((Spatial)this.label2);
        }
        this.lineQuad.updateEnds(v1, v2);
        this.geom.updateModelBound();
        this.resetLabelPosition();
    }

    protected void resetLabelPosition() {
        Vector3f v1 = this.end1.getView();
        Vector3f v2 = this.end2.getView();
        float rads = v2.x > v1.x ? FastMath.atan2((float)(v2.y - v1.y), (float)(v2.x - v1.x)) : FastMath.atan2((float)(v1.y - v2.y), (float)(v1.x - v2.x));
        Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, rads);
        this.lineLabel.setLocalRotation(rot);
        Vector3f offset = this.lineLabel.getPreferredSize().clone();
        offset.y = 0.0f;
        offset.x *= 0.5f;
        rot.mult(offset, offset);
        this.lineLabel.setLocalTranslation(v1.add(v2).mult(0.5f).subtract(offset));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[end1:" + this.end1 + ", end2:" + this.end2 + ", text:" + this.lineLabel.getText() + "]";
    }
}

