/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.google.common.base.MoreObjects;
import com.jme3.post.filters.BloomFilter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bloom
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(Bloom.class);
    public float blurScale = 1.5f;
    public float exposurePower = 5.0f;
    public float exposureCutOff = 0.0f;
    public float bloomIntensity = 2.0f;
    public float downSamplingFactor = 1.0f;

    public Bloom() {
    }

    public Bloom(float blurScale, float exposurePower, float exposureCutOff, float bloomIntensity, float downSamplingFactor) {
        this.blurScale = blurScale;
        this.exposurePower = exposurePower;
        this.exposureCutOff = exposureCutOff;
        this.bloomIntensity = bloomIntensity;
        this.downSamplingFactor = downSamplingFactor;
    }

    public void set(Bloom bloom) {
        this.blurScale = bloom.blurScale;
        this.exposurePower = bloom.exposurePower;
        this.exposureCutOff = bloom.exposureCutOff;
        this.bloomIntensity = bloom.bloomIntensity;
        this.downSamplingFactor = bloom.downSamplingFactor;
    }

    public Bloom clone() {
        try {
            return (Bloom)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("checked exceptions can be silly");
        }
    }

    public void apply(BloomFilter bloom) {
        bloom.setBlurScale(this.blurScale);
        bloom.setExposurePower(this.exposurePower);
        bloom.setExposureCutOff(this.exposureCutOff);
        bloom.setBloomIntensity(this.bloomIntensity);
        if ((double)Math.abs(bloom.getDownSamplingFactor() - this.downSamplingFactor) > 0.001) {
            log.info("Changing downsampling factor to:" + this.downSamplingFactor);
            bloom.setDownSamplingFactor(this.downSamplingFactor);
        }
    }

    public void extract(BloomFilter bloom) {
        this.blurScale = bloom.getBlurScale();
        this.exposurePower = bloom.getExposurePower();
        this.exposureCutOff = bloom.getExposureCutOff();
        this.bloomIntensity = bloom.getBloomIntensity();
        this.downSamplingFactor = bloom.getDownSamplingFactor();
    }

    public Bloom plus(Bloom bloom) {
        Bloom result = this.clone();
        result.blurScale += bloom.blurScale;
        result.exposurePower += bloom.exposurePower;
        result.exposureCutOff += bloom.exposureCutOff;
        result.bloomIntensity += bloom.bloomIntensity;
        result.downSamplingFactor += bloom.downSamplingFactor;
        return result;
    }

    public Bloom minus(Bloom bloom) {
        Bloom result = this.clone();
        result.blurScale -= bloom.blurScale;
        result.exposurePower -= bloom.exposurePower;
        result.exposureCutOff -= bloom.exposureCutOff;
        result.bloomIntensity -= bloom.bloomIntensity;
        result.downSamplingFactor -= bloom.downSamplingFactor;
        return result;
    }

    public Bloom multiply(double d) {
        Bloom result = this.clone();
        float f = (float)d;
        result.blurScale *= f;
        result.exposurePower *= f;
        result.exposureCutOff *= f;
        result.bloomIntensity *= f;
        result.downSamplingFactor *= f;
        return result;
    }

    public Bloom div(double d) {
        Bloom result = this.clone();
        float f = (float)d;
        result.blurScale /= f;
        result.exposurePower /= f;
        result.exposureCutOff /= f;
        result.bloomIntensity /= f;
        result.downSamplingFactor /= f;
        return result;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.blurScale), Float.valueOf(this.exposurePower), Float.valueOf(this.exposureCutOff), Float.valueOf(this.bloomIntensity), Float.valueOf(this.downSamplingFactor));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Bloom other = (Bloom)o;
        if (other.blurScale != this.blurScale) {
            return false;
        }
        if (other.exposurePower != this.exposurePower) {
            return false;
        }
        if (other.exposureCutOff != this.exposureCutOff) {
            return false;
        }
        if (other.bloomIntensity != this.bloomIntensity) {
            return false;
        }
        return other.downSamplingFactor == this.downSamplingFactor;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("blurScale", this.blurScale).add("exposurePower", this.exposurePower).add("exposureCutOff", this.exposureCutOff).add("bloomIntensity", this.bloomIntensity).add("downSamplingFactor", this.downSamplingFactor).toString();
    }
}

