/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityId;
import com.simsilica.es.Query;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.es.sql.SqlSession;
import com.simsilica.es.sql.TableQuery;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinQuery
implements Query {
    static Logger log = LoggerFactory.getLogger(JoinQuery.class);
    private final SqlEntityData parent;
    private final List<TableQuery> queries = new ArrayList<TableQuery>();
    private String statement;
    private List<Object> parms;

    public JoinQuery(SqlEntityData parent, TableQuery ... queries) {
        this.parent = parent;
        this.queries.addAll(Arrays.asList(queries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildQuery() {
        if (this.statement != null) {
            return;
        }
        this.parms = new ArrayList<Object>();
        StringBuilder tables = new StringBuilder();
        StringBuilder where = new StringBuilder();
        int index = 0;
        for (TableQuery query : this.queries) {
            try {
                String name = "t" + index;
                if (tables.length() > 0) {
                    tables.append(", ");
                }
                tables.append(query.getTableName() + " " + name);
                if (index > 0) {
                    if (where.length() > 0) {
                        where.append(" AND ");
                    }
                    where.append(name + ".entityId = t0.entityId");
                }
                if (query.getFilter() == null) continue;
                StringBuilder sub = new StringBuilder();
                int added = query.getTable().appendFilter(name, query.getFilter(), sub, this.parms);
                if (added == 0) continue;
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                if (added > 1) {
                    where.append("(");
                    where.append((CharSequence)sub);
                    where.append(")");
                    continue;
                }
                where.append((CharSequence)sub);
            }
            finally {
                ++index;
            }
        }
        StringBuilder sql = new StringBuilder("SELECT t0.entityId FROM ");
        sql.append((CharSequence)tables);
        if (where.length() > 0) {
            sql.append(" WHERE ");
            sql.append((CharSequence)where);
        }
        this.statement = sql.toString();
        if (log.isTraceEnabled()) {
            log.trace("Built SQL:" + this.statement + " parms:" + this.parms + " for:" + this);
        }
    }

    protected PreparedStatement prepareStatement(SqlSession session) throws SQLException {
        PreparedStatement st = session.prepareStatement(this.statement);
        int index = 1;
        for (Object o : this.parms) {
            st.setObject(index++, o);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<EntityId> execute() {
        this.buildQuery();
        try {
            SqlSession session = this.parent.getSession();
            PreparedStatement st = this.prepareStatement(session);
            HashSet<EntityId> results = new HashSet<EntityId>();
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                    Long entityId = rs.getLong(1);
                    results.add(new EntityId(entityId));
                }
            }
            return results;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:" + this.statement, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EntityId findFirst() {
        this.buildQuery();
        try {
            SqlSession session = this.parent.getSession();
            PreparedStatement st = this.prepareStatement(session);
            try (ResultSet rs = st.executeQuery();){
                if (!rs.next()) return null;
                Long entityId = rs.getLong(1);
                EntityId entityId2 = new EntityId(entityId);
                return entityId2;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:" + this.statement, e);
        }
    }

    @Override
    public Query join(Query other) {
        Query q;
        if (other.getClass() == TableQuery.class && (q = (TableQuery)other).getParent() == this.parent) {
            this.queries.add((TableQuery)q);
            this.statement = null;
            return this;
        }
        if (other.getClass() == JoinQuery.class) {
            q = (JoinQuery)other;
            if (((JoinQuery)q).parent == this.parent) {
                this.queries.addAll(((JoinQuery)q).queries);
                this.statement = null;
                return this;
            }
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("queries", this.queries).add("statement", (Object)this.statement).toString();
    }
}

