/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.opengl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import mythruna.client.opengl.DisplayModeProvider;
import mythruna.client.opengl.ModeInfo;
import mythruna.client.opengl.Resolution;
import mythruna.client.opengl.lwjgl2.Lwjgl2DisplayModeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPanel {
    static Logger log = LoggerFactory.getLogger(SettingsPanel.class);
    private DisplayModeProvider provider;
    private ListMultimap<Resolution, ModeInfo> fullscreenResolutions = MultimapBuilder.treeKeys().arrayListValues().build();
    private ListMultimap<Resolution, ModeInfo> windowResolutions = MultimapBuilder.treeKeys().arrayListValues().build();

    public SettingsPanel(DisplayModeProvider provider) {
        this.provider = provider;
        ModeInfo current = provider.getCurrentDisplayMode();
        for (ModeInfo mode : provider.getDisplayModes()) {
            Resolution resolution = mode.getResolution();
            if (mode.isFullscreen()) {
                this.fullscreenResolutions.put((Object)resolution, (Object)mode);
                continue;
            }
            this.windowResolutions.put((Object)resolution, (Object)mode);
        }
        log.info("Fullscreen:");
        for (Resolution resolution : this.fullscreenResolutions.keySet()) {
            log.info("  " + resolution + " (" + resolution.aspectRatioToString() + ")");
            for (ModeInfo mode : this.fullscreenResolutions.get((Object)resolution)) {
                log.info("    depth:" + mode.getBitsPerPixel() + " frequency:" + mode.getFrequency());
            }
        }
        log.info("Windowed:");
        for (Resolution resolution : this.windowResolutions.keySet()) {
            log.info("  " + resolution + " (" + resolution.aspectRatioToString() + ")");
        }
        log.info("current:" + current);
    }

    public static void test() {
        Lwjgl2DisplayModeProvider provider = new Lwjgl2DisplayModeProvider();
        SettingsPanel panel = new SettingsPanel(provider);
    }
}

