/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.RendererException;
import com.jme3.renderer.opengl.GL;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class GLDebug
implements InvocationHandler {
    protected Object obj;
    protected GL gl;
    protected Method methodGlGetError;

    private GLDebug(GL gl, Object obj) throws NoSuchMethodException {
        this.gl = gl;
        this.obj = obj;
        this.methodGlGetError = GL.class.getMethod("glGetError", new Class[0]);
    }

    protected String decodeError(int err) {
        String errMsg;
        switch (err) {
            case 0: {
                errMsg = "No Error";
                break;
            }
            case 1280: {
                errMsg = "Invalid enum argument";
                break;
            }
            case 1282: {
                errMsg = "Invalid operation";
                break;
            }
            case 1281: {
                errMsg = "Invalid numeric argument";
                break;
            }
            case 1285: {
                errMsg = "Out of memory";
                break;
            }
            case 1286: {
                errMsg = "Framebuffer is not complete";
                break;
            }
            case 1283: {
                errMsg = "Internal stack overflow";
                break;
            }
            case 1284: {
                errMsg = "Internal stack underflow";
                break;
            }
            default: {
                errMsg = "Unknown";
            }
        }
        return errMsg + " (Error Code: " + err + ")";
    }

    protected void checkError() {
        int err = this.gl.glGetError();
        if (err != 0) {
            throw new RendererException("An OpenGL error occurred - " + this.decodeError(err));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke(this.obj, args);
        if (method.equals(this.methodGlGetError)) {
            return result;
        }
        this.checkError();
        return result;
    }

    public static Object createProxy(GL gl, Object obj, Class<?> ... implementedInterfaces) {
        try {
            return Proxy.newProxyInstance(GLDebug.class.getClassLoader(), implementedInterfaces, (InvocationHandler)new GLDebug(gl, obj));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Could not initialize the proxy because the glGetError method wasn't found!", nsme);
        }
    }
}

