/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.simsilica.ethereal.LocalZoneIndex;
import com.simsilica.ethereal.SharedObject;
import com.simsilica.ethereal.SharedObjectSpace;
import com.simsilica.ethereal.Statistics;
import com.simsilica.ethereal.net.ClientStateMessage;
import com.simsilica.ethereal.net.FrameState;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.ethereal.net.ObjectStateMessage;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.net.RemoteTimeSource;
import com.simsilica.ethereal.net.SentState;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.util.IntRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateReceiver {
    static Logger log = LoggerFactory.getLogger(StateReceiver.class);
    private final Client client;
    private final ObjectStateProtocol objectProtocol;
    private final SharedObjectSpace space;
    private final LocalZoneIndex zoneIndex;
    private final ZoneGrid grid;
    private final RemoteTimeSource timeSource;
    private final Map<Integer, SentState> receivedStates = new TreeMap<Integer, SentState>();
    private long lastFrameTime;
    private final Statistics.Sequence frameTime;
    private final Statistics.Tracker messageSize;

    public StateReceiver(Client client, LocalZoneIndex zoneIndex, SharedObjectSpace space) {
        this.client = client;
        this.space = space;
        this.zoneIndex = zoneIndex;
        this.grid = zoneIndex.getGrid();
        this.objectProtocol = space.getObjectProtocol();
        this.timeSource = new RemoteTimeSource(-100000000L);
        this.frameTime = Statistics.getSequence("stateTime", true);
        this.messageSize = Statistics.getTracker("messageSize", 5, true);
    }

    public RemoteTimeSource getTimeSource() {
        return this.timeSource;
    }

    public void handleMessage(ObjectStateMessage msg) {
        this.timeSource.update(msg);
        if (log.isDebugEnabled()) {
            log.debug("Update state:" + (Object)((Object)msg));
        }
        this.client.send((Message)new ClientStateMessage(msg, 0L));
        this.messageSize.update(15 + msg.getBuffer().length);
        SentState state = msg.getState(this.objectProtocol);
        if (log.isDebugEnabled()) {
            log.debug("State:" + state);
        }
        this.receivedStates.put(state.messageId, state);
        this.processAcks(state.acked);
        for (FrameState frame : state.frames) {
            if (frame.time < this.lastFrameTime) continue;
            this.lastFrameTime = frame.time;
            if (log.isDebugEnabled()) {
                log.debug("** frame begin:" + frame.time);
            }
            this.frameTime.add(frame.time);
            this.space.beginFrame(this.lastFrameTime);
            ZoneKey center = this.grid.fromLongId(frame.columnId);
            if (this.zoneIndex.setCenter(center, new ArrayList<ZoneKey>(), new ArrayList<ZoneKey>())) {
                // empty if block
            }
            for (ObjectState objectState : frame.states) {
                SharedObject so;
                if (objectState.realId != null) {
                    so = this.space.getObject(objectState.networkId, objectState.realId);
                } else {
                    so = this.space.getObject(objectState.networkId);
                    if (so == null) {
                        log.warn("********* Network ID lookup returned null.  State:" + objectState + "  messageId:" + state.messageId);
                        continue;
                    }
                }
                if (!so.applyNetworkState(frame.time, objectState, this.zoneIndex) || !so.isFullyMarkedRemoved()) continue;
                this.space.removeObject(so);
            }
            this.space.endFrame();
        }
    }

    protected void processAcks(IntRange[] acked) {
        for (IntRange range : acked) {
            int min = range.getMinValue();
            int max = range.getMaxValue();
            for (int ackedId = min; ackedId <= max; ++ackedId) {
                List<FrameState> old;
                SentState sentState = this.ackReceivedState(ackedId);
                if (sentState == null || (old = sentState.frames) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Updating baseline for message:" + ackedId);
                }
                this.space.updateBaseline(old);
            }
        }
    }

    protected SentState ackReceivedState(int messageId) {
        if (this.receivedStates.isEmpty()) {
            return null;
        }
        Iterator<SentState> it = this.receivedStates.values().iterator();
        while (it.hasNext()) {
            SentState state = it.next();
            if (state.messageId < messageId) {
                it.remove();
                if (log.isTraceEnabled()) {
                    log.trace("Skipping stale state:" + state + " for messageId:" + messageId);
                    continue;
                }
                log.info("Skipping stale state for messageId:" + messageId);
                continue;
            }
            if (state.messageId == messageId) {
                it.remove();
                return state;
            }
            return null;
        }
        return null;
    }
}

