/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import java.io.Serializable;
import java.util.Objects;
import mythruna.world.tile.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureId<T>
implements Serializable {
    static Logger log = LoggerFactory.getLogger(FeatureId.class);
    private static final long serialVersionUID = 42L;
    private long id;
    private Class<T> type;

    public FeatureId(Class<T> type, long id) {
        this.type = type;
        this.id = id;
    }

    public static <T extends Feature> FeatureId<T> create(Class<T> type, long id) {
        return new FeatureId<T>(type, id);
    }

    public long getId() {
        return this.id;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FeatureId other = (FeatureId)o;
        if (other.id != this.id) {
            return false;
        }
        return other.type == this.type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.id + ", type:" + this.type.getSimpleName() + "]";
    }
}

