/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskUtils {
    static Logger log = LoggerFactory.getLogger(MaskUtils.class);
    private static final int TYPE_MASK = 1048575;
    private static final int SIDE_MASK_BITS = 63;
    private static final int SIDE_MASK_SHIFT = 26;
    private static final int SIDE_MASK = -67108864;

    public static int setType(int value, int type) {
        return value & 0xFFF00000 | type;
    }

    public static int getType(int value) {
        return value & 0xFFFFF;
    }

    public static int getSideMask(int value) {
        return value >> 26 & 0x3F;
    }

    public static int setSideMask(int value, int sideMask) {
        return value & 0x3FFFFFF | sideMask << 26;
    }

    public static BlockType getBlockType(int val) {
        int type = MaskUtils.getType(val);
        return BlockTypeIndex.get(type);
    }

    public static String valueToString(int value) {
        return "@" + MaskUtils.getType(value) + " #" + Integer.toBinaryString(MaskUtils.getSideMask(value));
    }

    public static void recalculateSideMasks(CellData data, int x, int y, int z, int defaultBorder) {
        int val;
        if (log.isTraceEnabled()) {
            log.trace("recalculateSideMasks(" + x + ", " + y + ", " + z + ")");
        }
        if ((val = data.getCell(x, y, z, -1)) == -1) {
            throw new IllegalArgumentException("Recalculating masks for invalid cell location:" + x + ", " + y + ", " + z);
        }
        BlockType centerType = MaskUtils.getBlockType(val);
        int centerMask = 0;
        for (Direction dir : Direction.values()) {
            Direction reverse;
            Vec3i v = dir.getVec3i();
            int nx = x + v.x;
            int ny = y + v.y;
            int nz = z + v.z;
            int nVal = data.getCell(nx, ny, nz, defaultBorder);
            BlockType neighbor = MaskUtils.getBlockType(nVal);
            if (log.isTraceEnabled()) {
                log.trace((Object)((Object)dir) + " (" + nx + ", " + ny + ", " + nz + ") -> " + Integer.toHexString(nVal));
            }
            if (centerType != null && MaskUtils.isSideVisible(centerType, dir, neighbor)) {
                centerMask |= dir.getBitMask();
            }
            if (neighbor == null) continue;
            int mask = MaskUtils.getSideMask(nVal);
            if (log.isTraceEnabled()) {
                log.trace("   existing:" + Integer.toHexString(mask));
            }
            mask = MaskUtils.isSideVisible(neighbor, reverse = dir.reverse(), centerType) ? (mask |= reverse.getBitMask()) : (mask &= ~reverse.getBitMask());
            if (log.isTraceEnabled()) {
                log.trace("   final:" + Integer.toHexString(mask));
            }
            data.setCell(nx, ny, nz, MaskUtils.setSideMask(nVal, mask));
        }
        data.setCell(x, y, z, MaskUtils.setSideMask(val, centerMask));
    }

    public static void oldRecalculateSideMasks(CellData data, int x, int y, int z) {
        int xStart = x - 1;
        int yStart = Math.max(0, y - 1);
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (x = xStart; x <= xEnd; ++x) {
            for (y = yStart; y <= yEnd; ++y) {
                for (z = zStart; z <= zEnd; ++z) {
                    int val = data.getCell(x, y, z);
                    BlockType type = MaskUtils.getBlockType(val);
                    int sideMask = 0;
                    if (type != null) {
                        for (Direction dir : Direction.values()) {
                            BlockType next = MaskUtils.getBlockType(data.getCell(x, y, z, dir, 0));
                            if (!MaskUtils.isSideVisible(type, dir, next)) continue;
                            sideMask |= dir.getBitMask();
                        }
                    }
                    data.setCell(x, y, z, MaskUtils.setSideMask(val, sideMask));
                }
            }
        }
    }

    public static void recalculateSideMasks(CellArray array, int x, int y, int z, boolean includeNeighbors) {
        int xStart = Math.max(0, x - (includeNeighbors ? 1 : 0));
        int yStart = Math.max(0, y - (includeNeighbors ? 1 : 0));
        int zStart = Math.max(0, z - (includeNeighbors ? 1 : 0));
        int xEnd = Math.min(array.getSizeX() - 1, x + (includeNeighbors ? 1 : 0));
        int yEnd = Math.min(array.getSizeY() - 1, y + (includeNeighbors ? 1 : 0));
        int zEnd = Math.min(array.getSizeZ() - 1, z + (includeNeighbors ? 1 : 0));
        for (x = xStart; x <= xEnd; ++x) {
            for (y = yStart; y <= yEnd; ++y) {
                for (z = zStart; z <= zEnd; ++z) {
                    int val = array.getCell(x, y, z);
                    BlockType type = MaskUtils.getBlockType(val);
                    int sideMask = 0;
                    if (type != null) {
                        for (Direction dir : Direction.values()) {
                            BlockType next = MaskUtils.getBlockType(array.getCell(x, y, z, dir, 0));
                            if (!MaskUtils.isSideVisible(type, dir, next)) continue;
                            sideMask |= dir.getBitMask();
                        }
                    }
                    array.setCell(x, y, z, MaskUtils.setSideMask(val, sideMask));
                }
            }
        }
    }

    public static int calculateSideMask(int x, int y, int z, CellData data) {
        return MaskUtils.calculateSideMask(x, y, z, data, false);
    }

    public static int calculateSideMask(int x, int y, int z, CellData data, boolean writeBack) {
        int val = data.getCell(x, y, z);
        BlockType type = MaskUtils.getBlockType(val);
        if (type == null) {
            return 0;
        }
        int sideMask = 0;
        for (Direction dir : Direction.values()) {
            BlockType next = MaskUtils.getBlockType(data.getCell(x, y, z, dir, 0));
            if (!MaskUtils.isSideVisible(type, dir, next)) continue;
            sideMask |= dir.getBitMask();
        }
        if (writeBack) {
            data.setCell(x, y, z, MaskUtils.setSideMask(val, sideMask));
        }
        return sideMask;
    }

    public static void calculateSideMasks(CellArray array) {
        MaskUtils.calculateSideMasks(array, array.getSizeX(), array.getSizeY(), array.getSizeZ());
    }

    public static void calculateSideMasks(CellData data, int size) {
        MaskUtils.calculateSideMasks(data, size, size, size);
    }

    public static int calculateSideMasks(CellData data, int xSize, int ySize, int zSize) {
        return MaskUtils.calculateSideMasks(data, 0, 0, 0, xSize, ySize, zSize);
    }

    public static int calculateSideMasks(CellData data, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        return MaskUtils.calculateSideMasks(data, xStart, yStart, zStart, xEnd, yEnd, zEnd, 0);
    }

    public static int calculateSideMasks(CellData data, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, int defaultValue) {
        int sideCount = 0;
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = yStart; y < yEnd; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    int val = data.getCell(x, y, z);
                    BlockType type = MaskUtils.getBlockType(val);
                    if (type == null) continue;
                    int sideMask = 0;
                    for (Direction dir : Direction.values()) {
                        BlockType next = MaskUtils.getBlockType(data.getCell(x, y, z, dir, defaultValue));
                        if (!MaskUtils.isSideVisible(type, dir, next)) continue;
                        sideMask |= dir.getBitMask();
                        ++sideCount;
                    }
                    data.setCell(x, y, z, MaskUtils.setSideMask(val, sideMask));
                }
            }
        }
        return sideCount;
    }

    public static boolean isSideVisible(BlockType cell, Direction dir, BlockType other) {
        if (cell == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        log.trace("isSideVisible()");
        int ourGroup = cell.getTransparencyGroup();
        int otherGroup = other.getTransparencyGroup();
        if (!(ourGroup == otherGroup && ourGroup != -1 || otherGroup == 0 && ourGroup >= 0)) {
            if (log.isTraceEnabled()) {
                log.trace("group mismatch, ourGroup:" + ourGroup + "  otherGroup:" + otherGroup);
            }
            return true;
        }
        Direction back = dir.reverse();
        if (other.isSolid(back)) {
            log.trace("other is solid");
            return false;
        }
        if (cell.isSolid(dir)) {
            log.trace("cell is solid");
            return true;
        }
        BoundaryShape us = cell.getShape(dir);
        BoundaryShape them = other.getShape(back);
        if (log.isTraceEnabled()) {
            log.trace("us:" + us + "  them:" + them);
        }
        return !us.isMatchingFace(them);
    }
}

