
import mythruna.shell.*;

import org.apache.logging.log4j.*;
import org.apache.logging.log4j.spi.*;
import org.apache.logging.log4j.core.config.*;

def logLevelHelp = [
    "<category> [level] - views or changes the log level for the specifed",
    "                     category.",
    "Where:",
    "  <categiry> - is the category name.",
    "  [level] - is the optional log level as TRACE, INFO, etc.",
    "",
    "If [level] is not included then the current level is echoed."
]

setupLogLevel = { targetShell ->
    ShellCommand cmd = new AbstractShellCommand(logLevelHelp as String[]) {
        public Object execute( CommandShell shell, String args ) {
            String[] tokens = args.split("\\s");
            if( tokens.length == 1 ) {
                Logger logger = LogManager.getLogger(tokens[0]);
                shell.echo("" + tokens[0] + " level:" + logger?.getLevel());
            } else if( tokens.length > 1 ) {
                Logger logger = LogManager.getLogger(tokens[0]);
                Level level;
                try {
                    level = Level.valueOf(tokens[1]);
                } catch( IllegalArgumentException e ) {
                    log.info("Error converting:" + tokens[1], e);
                    echo("Invalid level string:" + tokens[1]);
                    return null;
                }
                Configurator.setLevel(tokens[0], level);
                shell.echo("" + tokens[0] + " new level:" + logger?.getLevel());
            } else {
                shell.echo("No category specified.");
            }
            return null;
        }
    };
    targetShell.updateCommand("log-level", cmd);
}

// This already exists in server-shell-commands and so gets confusing...
// and this isn't even used here anyway.
//updateShellCommand = { CommandShell target, String name, List help, Closure doIt ->
//    ShellCommand cmd = new AbstractShellCommand(help as String[]) {
//                public Object execute( CommandShell shell, String args ) {
//                    // rehydrate(Object delegate, Object owner, Object thisObject)
//                    Closure c = doIt.rehydrate(shell, doIt.owner, doIt);
//                    int length = doIt.getParameterTypes().length;
//                    if( length == 2 ) {
//                        c(shell, args);
//                    } else {
//                        c(args);
//                    }
//                    return null;
//                }
//            };
//    target.updateCommand(name, cmd);
//    return cmd;
//}
//

