/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import mythruna.client.net.NetworkState;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.DataSessionListener;
import mythruna.net.client.DataSessionClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricIndexSetup
extends AbstractClientService {
    static Logger log = LoggerFactory.getLogger(FabricIndexSetup.class);
    private Application app;
    private NetworkState networkState;
    private DataSessionClientService session;

    public FabricIndexSetup(Application app, NetworkState networkState) {
        this.app = app;
        this.networkState = networkState;
    }

    protected void onInitialize(ClientServiceManager serviceManager) {
        log.info("onInitialize()");
        this.session = (DataSessionClientService)serviceManager.getService(DataSessionClientService.class);
        log.info("session:" + this.session);
        this.session.addDataSessionListener(new DataSessionListener(){

            public void dataAvailable() {
                FabricIndexSetup.this.app.enqueue(() -> FabricIndexSetup.this.setupFabric());
            }
        });
    }

    public void start() {
        log.info("start()");
    }

    protected void setupFabric() {
        log.info("setupFabric()");
        try {
            log.info("getting fabrics...");
            FabricTypeData fabrics = this.session.getFabricTypeData();
            log.info("fabrics:" + fabrics);
            FabricTypeIndex.reset();
            FabricTypeIndex.initialize((FabricTypeData)fabrics);
            log.info("getting shapes...");
            SwatchShapeData shapes = this.session.getSwatchShapeData();
            log.info("shapes:" + shapes);
            SwatchShapeIndex.reset();
            SwatchShapeIndex.initialize((SwatchShapeData)shapes);
            this.networkState.trigger("success");
        }
        catch (Throwable t) {
            this.networkState.setFailed("Synching fabric data", t);
        }
        finally {
            log.info("Block finished.");
        }
    }

    protected void cleanupFabric() {
        log.info("cleanupFabric()");
        FabricTypeIndex.reset();
        SwatchShapeIndex.reset();
    }
}

