/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTypeSelector
extends Container {
    static Logger log = LoggerFactory.getLogger(BlockTypeSelector.class);
    private SetMultimap<String, String> baseShapes = MultimapBuilder.treeKeys().treeSetValues().build();
    private VersionedList<String> baseNames = new VersionedList();
    private VersionedList<String> shapeNames = new VersionedList();
    private Selector<String> base;
    private VersionedReference<String> baseRef;
    private Selector<String> shape;
    private VersionedReference<String> shapeRef;
    private List<Integer> rotations = new ArrayList<Integer>();
    private BlockName lastName = null;
    private int selectedType = -1;
    private int rotation = 0;
    private VersionedHolder<BlockType> selectedBlockType = new VersionedHolder();

    public BlockTypeSelector() {
        super(new ElementId("block.popup"));
        if (this.selectedType == -1) {
            this.selectedType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"));
        }
        this.selectedBlockType.updateObject((Object)BlockTypeIndex.get((int)this.selectedType));
        this.addChild((Node)new Label("Temporary Block Palette", this.getElementId().child("window.title")), new Object[0]);
        Container selectors = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        selectors.addChild((Node)new Label("Base:", this.getElementId().child("label")), new Object[0]);
        this.base = (Selector)selectors.addChild((Node)new Selector(this.baseNames, this.getElementId().child("selector")), new Object[0]);
        this.baseRef = this.base.createSelectedItemReference();
        selectors.addChild((Node)new Label("Shape:", this.getElementId().child("label")), new Object[0]);
        this.shape = (Selector)selectors.addChild((Node)new Selector(this.shapeNames, this.getElementId().child("selector")), new Object[0]);
        this.shapeRef = this.shape.createSelectedItemReference();
        selectors.addChild((Node)new Label(""), new Object[0]);
        for (BlockType type : BlockTypeIndex.getTypes()) {
            if (type == null) continue;
            BlockName name = type.getName();
            this.baseShapes.put((Object)name.getBase(), (Object)name.getShape());
        }
        this.baseNames.addAll((Collection)this.baseShapes.keySet());
        this.resetFields();
        this.resetSelectedType();
    }

    public void setSelectedType(int selectedType) {
        if (this.selectedType == selectedType) {
            return;
        }
        this.selectedType = selectedType;
        this.resetFields();
        this.resetRotations();
        this.rotation = 0;
        for (int i = 0; i < this.rotations.size(); ++i) {
            if (this.rotations.get(i) != selectedType) continue;
            log.info("Found rotation:" + i);
            this.rotation = i;
            break;
        }
        this.resetSelectedType();
        this.resetFields();
    }

    public int getSelectedType() {
        return this.selectedType;
    }

    public VersionedReference<BlockType> createSelectedTypeRef() {
        return this.selectedBlockType.createReference();
    }

    public void adjustRotation(int delta) {
        log.info("adjustRotation(" + delta + ")");
        this.rotation += delta;
        if (this.rotation < 0) {
            this.rotation = !this.rotations.isEmpty() ? (this.rotation += this.rotations.size()) : 0;
        }
        this.rotation %= this.rotations.size();
        this.resetSelectedType();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        if (this.baseRef.update()) {
            this.resetShapes((String)this.baseRef.get());
            changed = true;
        }
        if (this.shapeRef.update()) {
            changed = true;
        }
        if (changed) {
            this.resetSelectedType();
        }
    }

    protected void resetShapes(String baseName) {
        String original = (String)this.shape.getSelectedItem();
        this.shapeNames.clear();
        Set set = this.baseShapes.get((Object)baseName);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (String s : set) {
            this.shapeNames.add((Object)s);
        }
        if (this.shapeNames.contains((Object)original)) {
            this.shape.setSelectedItem((Object)original);
        } else if (this.shapeNames.contains((Object)"cube")) {
            this.shape.setSelectedItem((Object)"cube");
        } else if (!this.shapeNames.isEmpty()) {
            this.shape.setSelectedItem((Object)((String)this.shapeNames.get(0)));
        }
    }

    protected void resetFields() {
        BlockType selected = BlockTypeIndex.get((int)this.selectedType);
        if (selected == null) {
            return;
        }
        BlockName name = selected.getName();
        this.base.setSelectedItem((Object)name.getBase());
        this.baseRef.update();
        this.resetShapes(name.getBase());
        this.shape.setSelectedItem((Object)name.getShape());
    }

    protected void resetRotations() {
        BlockType[] types = BlockTypeIndex.getTypes();
        String baseName = (String)this.base.getSelectedItem();
        String shapeName = (String)this.shape.getSelectedItem();
        if (this.lastName == null || !Objects.equals(this.lastName.getBase(), baseName) || !Objects.equals(this.lastName.getShape(), shapeName)) {
            this.rotations.clear();
            for (int i = 0; i < types.length; ++i) {
                BlockName name;
                BlockType type = types[i];
                if (type == null || !Objects.equals((name = type.getName()).getBase(), baseName) || !Objects.equals(name.getShape(), shapeName)) continue;
                this.rotations.add(i);
            }
            this.lastName = new BlockName(baseName, shapeName);
        }
    }

    protected void resetSelectedType() {
        this.resetRotations();
        this.selectedType = this.rotations.isEmpty() ? 0 : this.rotations.get(this.rotation % this.rotations.size());
        this.selectedBlockType.updateObject((Object)BlockTypeIndex.get((int)this.selectedType));
    }
}

