/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileLocator
implements AssetLocator {
    private File root;

    @Override
    public void setRootPath(String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException("rootPath cannot be null");
        }
        try {
            this.root = new File(rootPath).getCanonicalFile();
            if (!this.root.isDirectory()) {
                throw new IllegalArgumentException("Given root path \"" + this.root + "\" is not a directory");
            }
        }
        catch (IOException ex) {
            throw new AssetLoadException("Root path is invalid", ex);
        }
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String name = key.getName();
        File file = new File(this.root, name);
        if (file.exists() && file.isFile()) {
            try {
                String canonical = file.getCanonicalPath();
                String absolute = file.getAbsolutePath();
                if (!canonical.endsWith(absolute)) {
                    throw new AssetNotFoundException("Asset name doesn't match requirements.\n\"" + canonical + "\" doesn't match \"" + absolute + "\"");
                }
            }
            catch (IOException ex) {
                throw new AssetLoadException("Failed to get file canonical path " + file, ex);
            }
            return new AssetInfoFile(manager, key, file);
        }
        return null;
    }

    private static class AssetInfoFile
    extends AssetInfo {
        private final File file;

        public AssetInfoFile(AssetManager manager, AssetKey key, File file) {
            super(manager, key);
            this.file = file;
        }

        @Override
        public InputStream openStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException ex) {
                throw new AssetLoadException("Failed to open file: " + this.file, ex);
            }
        }
    }
}

