/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiMaterial;
import java.util.Objects;

public class IconComponent
extends AbstractGuiComponent
implements Cloneable,
ColoredComponent {
    private Geometry icon;
    private GuiMaterial material;
    private String imagePath;
    private Texture image;
    private ColorRGBA color;
    private float alpha = 1.0f;
    private float xMargin = 0.0f;
    private float yMargin = 0.0f;
    private float zOffset = 0.01f;
    private float alphaDiscard = 0.0f;
    private HAlignment hAlign = HAlignment.Left;
    private VAlignment vAlign = VAlignment.Center;
    private Vector3f offset = null;
    private Vector2f iconScale;
    private Vector2f iconSize;
    private boolean overlay = false;
    private boolean lit = false;

    public IconComponent(String imagePath) {
        this(imagePath, 1.0f, 0.0f, 0.0f, 0.01f, false);
    }

    public IconComponent(String imagePath, float iconScale) {
        this(imagePath, iconScale, 0.0f, 0.0f, 0.01f, false);
    }

    public IconComponent(String imagePath, float iconScale, float xMargin, float yMargin, float zOffset, boolean lit) {
        this(imagePath, new Vector2f(iconScale, iconScale), xMargin, yMargin, zOffset, lit);
    }

    public IconComponent(String imagePath, Vector2f iconScale, float xMargin, float yMargin, float zOffset, boolean lit) {
        this(GuiGlobals.getInstance().loadTexture(imagePath, false, false), iconScale, xMargin, yMargin, zOffset, lit);
    }

    public IconComponent(Texture image, Vector2f iconScale, float xMargin, float yMargin, float zOffset, boolean lit) {
        if (image == null) {
            throw new IllegalArgumentException("Image texture cannot be null");
        }
        this.imagePath = image.getName();
        this.image = image;
        this.iconScale = iconScale;
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.zOffset = zOffset;
        this.lit = lit;
        this.icon = this.createIcon();
    }

    @Override
    public IconComponent clone() {
        IconComponent result = (IconComponent)super.clone();
        result.icon = null;
        result.material = this.material.clone();
        result.icon = result.createIcon();
        return result;
    }

    @Override
    public void attach(GuiControl parent) {
        super.attach(parent);
        if (this.icon != null) {
            this.getNode().attachChild((Spatial)this.icon);
        }
    }

    @Override
    public void detach(GuiControl parent) {
        if (this.icon != null) {
            this.getNode().detachChild((Spatial)this.icon);
        }
        super.detach(parent);
    }

    public void setImageTexture(Texture t) {
        this.image = t;
        if (this.material != null) {
            this.material.setTexture(this.image);
        }
    }

    public Texture getImageTexture() {
        return this.image;
    }

    @Override
    public void setColor(ColorRGBA c) {
        this.color = c;
        this.resetColor();
    }

    protected void resetColor() {
        if (this.material == null) {
            return;
        }
        if (this.alpha >= 1.0f) {
            this.material.setColor(this.color);
        } else {
            ColorRGBA adjusted = this.color != null ? this.color.clone() : ColorRGBA.White.clone();
            adjusted.a *= this.alpha;
            this.material.setColor(adjusted);
        }
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    public void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
        this.resetColor();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public void setIconScale(float scale) {
        if (scale == this.iconScale.x && scale == this.iconScale.y) {
            return;
        }
        this.setIconScale(new Vector2f(scale, scale));
    }

    public void setIconScale(Vector2f scale) {
        if (this.iconScale.equals((Object)scale)) {
            return;
        }
        this.iconScale.set(scale);
        this.icon = this.createIcon();
        this.invalidate();
    }

    public Vector2f getIconScale() {
        return this.iconScale;
    }

    public void setIconSize(Vector2f iconSize) {
        if (Objects.equals(this.iconSize, iconSize)) {
            return;
        }
        this.iconSize = iconSize;
        this.icon = this.createIcon();
        this.invalidate();
    }

    public Vector2f getIconSize() {
        return this.iconSize;
    }

    public void setHAlignment(HAlignment a) {
        if (this.hAlign == a) {
            return;
        }
        this.hAlign = a;
        this.resetAlignment();
    }

    public HAlignment getHAlignment() {
        return this.hAlign;
    }

    public void setVAlignment(VAlignment a) {
        if (this.vAlign == a) {
            return;
        }
        this.vAlign = a;
        this.resetAlignment();
    }

    public VAlignment getVAlignment() {
        return this.vAlign;
    }

    public void setMargin(float x, float y) {
        this.xMargin = x;
        this.yMargin = y;
        this.invalidate();
    }

    public void setMargin(Vector2f margin) {
        if (margin == null) {
            throw new IllegalArgumentException("Margin cannot be null");
        }
        this.setMargin(margin.x, margin.y);
    }

    public Vector2f getMargin() {
        return new Vector2f(this.xMargin, this.yMargin);
    }

    public void setZOffset(float z) {
        this.zOffset = z;
        this.invalidate();
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setOffset(Vector3f v) {
        this.offset = v;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setOverlay(boolean f) {
        if (this.overlay == f) {
            return;
        }
        this.overlay = f;
        this.invalidate();
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setAlphaDiscard(float alphaDiscard) {
        if (this.alphaDiscard == alphaDiscard) {
            return;
        }
        this.alphaDiscard = alphaDiscard;
        if (this.material != null) {
            if (alphaDiscard == 0.0f) {
                this.material.getMaterial().clearParam("AlphaDiscardThreshold");
            } else {
                this.material.getMaterial().setFloat("AlphaDiscardThreshold", alphaDiscard);
            }
        }
    }

    public float getAlphaDiscard() {
        return this.alphaDiscard;
    }

    public GuiMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        if (this.overlay) {
            return;
        }
        Vector2f imageSize = this.getEffectiveIconSize();
        float width = this.iconScale.x * imageSize.x + this.xMargin * 2.0f;
        float height = this.iconScale.y * imageSize.y + this.yMargin * 2.0f;
        switch (this.vAlign) {
            case Top: 
            case Bottom: {
                size.y += height;
                break;
            }
            case Center: {
                size.y = Math.max(height, size.y);
            }
        }
        switch (this.hAlign) {
            case Left: 
            case Right: {
                size.x += width;
                break;
            }
            case Center: {
                size.x = Math.max(width, size.x);
            }
        }
        size.z += Math.abs(this.zOffset);
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        Vector2f imageSize = this.getEffectiveIconSize();
        float width = this.iconScale.x * imageSize.x;
        float height = this.iconScale.y * imageSize.y;
        float boxWidth = width + this.xMargin * 2.0f;
        float boxHeight = height + this.yMargin * 2.0f;
        float cx = 0.0f;
        float cy = 0.0f;
        switch (this.hAlign) {
            case Left: {
                cx = pos.x + boxWidth * 0.5f;
                if (this.overlay) break;
                pos.x += boxWidth;
                size.x -= boxWidth;
                break;
            }
            case Right: {
                cx = pos.x + size.x - boxWidth * 0.5f;
                if (this.overlay) break;
                size.x -= boxWidth;
                break;
            }
            case Center: {
                cx = pos.x + size.x * 0.5f;
            }
        }
        switch (this.vAlign) {
            case Top: {
                cy = pos.y - boxHeight * 0.5f;
                if (this.overlay) break;
                pos.y -= boxHeight;
                size.y -= boxHeight;
                break;
            }
            case Bottom: {
                cy = pos.y - size.y + boxWidth * 0.5f;
                if (this.overlay) break;
                size.y -= boxHeight;
                break;
            }
            case Center: {
                cy = pos.y - size.y * 0.5f;
            }
        }
        this.icon.setLocalTranslation(cx - width * 0.5f, cy - height * 0.5f, pos.z);
        if (this.offset != null) {
            this.icon.move(this.offset);
        }
        pos.z += this.zOffset;
        size.z -= Math.abs(this.zOffset);
        this.icon.setCullHint(Spatial.CullHint.Inherit);
    }

    protected void resetAlignment() {
        this.invalidate();
    }

    protected Geometry getIcon() {
        return this.icon;
    }

    protected Geometry createIcon() {
        Vector2f imageSize = this.getEffectiveIconSize();
        float width = this.iconScale.x * imageSize.x;
        float height = this.iconScale.y * imageSize.y;
        Quad q = new Quad(width, height);
        Geometry geom = new Geometry("icon:" + this.imagePath, (Mesh)q);
        if (this.material == null) {
            this.material = GuiGlobals.getInstance().createMaterial(this.lit);
            this.material.setColor(this.color);
            this.material.setTexture(this.image);
            this.material.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            if (this.alphaDiscard > 0.0f) {
                this.material.getMaterial().setFloat("AlphaDiscardThreshold", this.alphaDiscard);
            }
        }
        geom.setMaterial(this.material.getMaterial());
        geom.setCullHint(Spatial.CullHint.Always);
        if (this.isAttached()) {
            this.getNode().attachChild((Spatial)geom);
        }
        return geom;
    }

    protected Vector2f getEffectiveIconSize() {
        if (this.iconSize != null) {
            return this.iconSize;
        }
        if (this.image != null) {
            return new Vector2f((float)this.image.getImage().getWidth(), (float)this.image.getImage().getHeight());
        }
        return Vector2f.ZERO;
    }
}

