/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.simsilica.mworld.db.ObjectDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectDb<K, V>
implements ObjectDb<K, V> {
    static Logger log = LoggerFactory.getLogger(AbstractObjectDb.class);
    private LoadingCache<K, V> cache = CacheBuilder.newBuilder().removalListener(new RemovalListener<K, V>(){

        public void onRemoval(RemovalNotification<K, V> notification) {
            if (log.isDebugEnabled()) {
                log.debug("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }
    }).weakValues().build(new CacheLoader<K, V>(){

        public V load(K key) {
            return AbstractObjectDb.this.loadObject(key);
        }
    });

    protected AbstractObjectDb() {
    }

    protected LoadingCache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public V get(K key) {
        return (V)this.cache.getUnchecked(key);
    }

    protected abstract V loadObject(K var1);
}

