/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.db.GeneratedColumnDb;
import com.simsilica.mworld.util.RevisionFiles;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionedGeneratedColumnDb
extends GeneratedColumnDb {
    static Logger log = LoggerFactory.getLogger(RevisionedGeneratedColumnDb.class);
    private final RevisionFiles revisions;
    private Supplier<Long> currentRevision;

    public RevisionedGeneratedColumnDb(Function<ColumnId, ColumnData> generator, Function<ColumnId, File> fileFunc, RevisionFiles revisions, Supplier<Long> currentRevision) {
        super(generator, fileFunc);
        this.revisions = revisions;
        this.currentRevision = currentRevision;
    }

    public void setCurrentRevision(Supplier<Long> currentRevision) {
        this.currentRevision = currentRevision;
    }

    public Supplier<Long> getCurrentRevision() {
        return this.currentRevision;
    }

    public List<Long> getRevisions(ColumnId columnId) {
        File file = this.columnToFile(columnId);
        try {
            return this.revisions.getRevisions(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving revisions for:" + columnId + " current:" + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverColumn(ColumnId columnId, long revision) {
        log.info("recoverColumn(" + columnId + ", " + revision + ")");
        File file = this.columnToFile(columnId);
        File backup = this.revisions.getRevision(file, revision);
        if (!backup.exists()) {
            log.warn("Revision:" + revision + " doesn't exist for:" + columnId + " at:" + backup + "  original:" + file);
            return false;
        }
        ColumnData original = this.getColumn(columnId);
        log.info("original column version:" + original.getVersion());
        ColumnData columnData = original;
        synchronized (columnData) {
            ColumnData reverted = this.readColumn(backup);
            log.info("recover column version:" + reverted.getVersion());
            original.setData(reverted);
            this.writeColumn(file, original);
        }
        return true;
    }

    @Override
    protected void writeColumn(File f, ColumnData col) {
        long rev = this.currentRevision.get();
        long current = col.getBranchRevision();
        if (current < rev) {
            if (f.exists()) {
                File backupFile = this.revisions.getRevision(f, rev);
                if (backupFile.exists()) {
                    log.error("Backup file already exists:" + backupFile + " for:" + f + "  baseline:" + rev + " current:" + current, new Throwable("stack-trace"));
                } else {
                    try {
                        log.info("Backing up:" + f);
                        this.revisions.backup(f, rev);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error backing up column:" + f, e);
                    }
                }
            } else {
                log.warn("Column with older data has no original:" + f);
            }
        }
        col.setBranchRevision(rev);
        super.writeColumn(f, col);
    }
}

