/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.tile.pc.PointIndex;
import com.simsilica.mworld.tile.pc.PointIndexFunction;
import com.simsilica.mworld.tile.pc.PointType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointTypeMapping
implements PointIndexFunction {
    static Logger log = LoggerFactory.getLogger(PointTypeMapping.class);
    private final int TERRAIN_BITS = CellGenType.Terrain.getBits();
    private final int FLORA_BITS = CellGenType.Flora.getBits();
    private PointType defaultType = new PointType(0);
    private Map<Integer, Integer> typeMap = new HashMap<Integer, Integer>();

    public PointTypeMapping() {
        int brown = 8;
        int tan = 36;
        int slate = 40;
        int grayTan = 39;
        int yellow = 37;
        BlockType[] types = BlockTypeIndex.getTypes();
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null) continue;
            String base = type.getName().getBase();
            if ("W&D".equals(base)) {
                this.typeMap.put(i, tan);
                continue;
            }
            if ("aura".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("awning".equals(base)) {
                this.typeMap.put(i, 36);
                continue;
            }
            if ("bad".equals(base)) {
                this.typeMap.put(i, 22);
                continue;
            }
            if ("bladder".equals(base)) {
                this.typeMap.put(i, 36);
                continue;
            }
            if ("bladder-low".equals(base)) {
                this.typeMap.put(i, 36);
                continue;
            }
            if ("bmarble".equals(base)) {
                this.typeMap.put(i, 50);
                continue;
            }
            if ("clay".equals(base)) {
                this.typeMap.put(i, 58);
                continue;
            }
            if ("clay-brick".equals(base)) {
                this.typeMap.put(i, 8);
                continue;
            }
            if ("clay-brick-stucco".equals(base)) {
                this.typeMap.put(i, 2);
                continue;
            }
            if ("mud-brick".equals(base)) {
                this.typeMap.put(i, 8);
                continue;
            }
            if ("mud-brick-stucco".equals(base)) {
                this.typeMap.put(i, 2);
                continue;
            }
            if ("cobble".equals(base)) {
                this.typeMap.put(i, 58);
                continue;
            }
            if ("corn".equals(base)) {
                this.typeMap.put(i, 64);
                continue;
            }
            if ("dark-granite".equals(base)) {
                this.typeMap.put(i, 49);
                continue;
            }
            if ("dirt".equals(base)) {
                this.typeMap.put(i, brown);
                continue;
            }
            if ("dry-grass".equals(base)) {
                this.typeMap.put(i, 37);
                continue;
            }
            if ("fire".equals(base)) {
                this.typeMap.put(i, 18);
                continue;
            }
            if ("flora".equals(base)) {
                this.typeMap.put(i, 64);
                continue;
            }
            if ("glass".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("grass".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("hedge".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("ice".equals(base)) {
                this.typeMap.put(i, 44);
                continue;
            }
            if ("iron".equals(base)) {
                this.typeMap.put(i, 50);
                continue;
            }
            if ("jack-o-lantern".equals(base)) {
                this.typeMap.put(i, 9);
                continue;
            }
            if ("leather".equals(base)) {
                this.typeMap.put(i, 7);
                continue;
            }
            if ("leaves".equals(base)) {
                this.typeMap.put(i, 29);
                continue;
            }
            if ("leaves2".equals(base)) {
                this.typeMap.put(i, 31);
                continue;
            }
            if ("light".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("log".equals(base)) {
                this.typeMap.put(i, 8);
                continue;
            }
            if ("magic-blue".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("magic-green".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("magic-red".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("magic-white".equals(base)) {
                this.typeMap.put(i, 0);
                continue;
            }
            if ("mud-stone".equals(base)) {
                this.typeMap.put(i, slate);
                continue;
            }
            if ("pine".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("pumpkin".equals(base)) {
                this.typeMap.put(i, 9);
                continue;
            }
            if ("rock".equals(base)) {
                this.typeMap.put(i, 51);
                continue;
            }
            if ("rock-capped".equals(base)) {
                this.typeMap.put(i, 51);
                continue;
            }
            if ("sand".equals(base)) {
                this.typeMap.put(i, 2);
                continue;
            }
            if ("sandstone".equals(base)) {
                this.typeMap.put(i, 20);
                continue;
            }
            if ("sandstone-cobble".equals(base)) {
                this.typeMap.put(i, 5);
                continue;
            }
            if ("shingles".equals(base)) {
                this.typeMap.put(i, grayTan);
                continue;
            }
            if ("shrub".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("snow".equals(base)) {
                this.typeMap.put(i, 41);
                continue;
            }
            if ("steel".equals(base)) {
                this.typeMap.put(i, 43);
                continue;
            }
            if ("steel-black".equals(base)) {
                this.typeMap.put(i, 49);
                continue;
            }
            if ("steel-light".equals(base)) {
                this.typeMap.put(i, 42);
                continue;
            }
            if ("stone".equals(base)) {
                this.typeMap.put(i, 59);
                continue;
            }
            if ("thatch".equals(base)) {
                this.typeMap.put(i, yellow);
                continue;
            }
            if ("trunk".equals(base)) {
                this.typeMap.put(i, 38);
                continue;
            }
            if ("waddle".equals(base)) {
                this.typeMap.put(i, brown);
                continue;
            }
            if ("wmarble".equals(base)) {
                this.typeMap.put(i, 42);
                continue;
            }
            if ("wood".equals(base)) {
                this.typeMap.put(i, brown);
                continue;
            }
            if (!"wood-frame".equals(base)) continue;
            this.typeMap.put(i, 0);
        }
    }

    public PointIndex getPointIndex(int rawType, int type, PointIndex target) {
        int typeBits = CellGenType.getTypeBits((int)rawType);
        if (typeBits == this.TERRAIN_BITS) {
            return null;
        }
        if (target == null) {
            target = new PointIndex();
        }
        if (typeBits == this.FLORA_BITS) {
            target.set(null, (byte)0);
            return target;
        }
        Integer remap = this.typeMap.get(type);
        if (remap != null) {
            type = remap;
        }
        if (type == 0) {
            target.set(null, (byte)0);
            return target;
        }
        target.set(this.defaultType, (byte)type);
        return target;
    }
}

