/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.FractalUtils;
import com.simsilica.fractal.PerlinNoise;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.Samplers;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.util.ArrayList;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterBody
extends AbstractMorphology {
    static Logger log = LoggerFactory.getLogger(WaterBody.class);
    public static final int TYPE_FRESH_WATER = 0;
    private static boolean USE_TERRAIN_INFLUENCE = true;
    private static boolean USE_OFFSET_FRACTALS = true;
    private static boolean USE_DEPTH_FRACTAL = true;
    private static final double OFFSET_RESOLUTION = 0.041666666666666664;
    private static final Sampler X_OFFSET = Samplers.resample((Sampler)new PerlinNoise(1L), (double)0.041666666666666664, (double)1.0, (double)0.041666666666666664);
    private static final Sampler Z_OFFSET = Samplers.resample((Sampler)new PerlinNoise(2L), (double)0.041666666666666664, (double)1.0, (double)0.041666666666666664);
    private static final double HALF_INV_SQRT2 = 1.0 / (Math.sqrt(2.0) * 0.5);
    private static final double DEPTH_RESOLUTION = 0.0625;
    private static final Sampler DEPTH_OFFSET = Samplers.resample((Sampler)new PerlinNoise(0L), (double)0.0625, (double)1.0, (double)0.0625);
    private int type;
    private Vec3i center;
    private int depth;
    private int radius;
    private int influence;
    private int carveElevation;
    private int carveRadius;
    private int carveInfluence;
    private int variation;

    public WaterBody(Vec3i center, int depth, int radius, int influence, int carveElevation, int carveRadius, int carveInfluence, int variation) {
        this(0, center, depth, radius, influence, carveElevation, carveRadius, carveInfluence, variation);
    }

    public WaterBody(int type, Vec3i center, int depth, int radius, int influence, int carveElevation, int carveRadius, int carveInfluence, int variation) {
        this.type = type;
        this.center = center;
        this.depth = depth;
        this.radius = radius;
        this.influence = influence;
        this.carveElevation = carveElevation;
        this.carveRadius = carveRadius;
        this.carveInfluence = carveInfluence;
        this.variation = variation;
    }

    public int getType() {
        return this.type;
    }

    public Vec3i getCenter() {
        return this.center;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getInfluence() {
        return this.influence;
    }

    public int getCarveElevation() {
        if (this.carveElevation < 128) {
            this.carveElevation += 128;
        }
        return this.carveElevation;
    }

    public int getCarveRadius() {
        return this.carveRadius;
    }

    public int getCarveInfluence() {
        return this.carveInfluence;
    }

    public int getVariation() {
        return this.variation;
    }

    public Vec3i getMin() {
        int extra = this.influence + this.variation;
        return new Vec3i(this.center.x - extra, this.center.y, this.center.z - extra);
    }

    public Vec3i getMax() {
        int extra = this.influence + this.variation;
        return new Vec3i(this.center.x + extra, this.center.y, this.center.z + extra);
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int extra = this.influence + this.variation;
        int xMin = this.center.x - extra - origin.x;
        int zMin = this.center.z - extra - origin.z;
        int xMax = this.center.x + extra - origin.x;
        int zMax = this.center.z + extra - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        int extra = this.influence + this.variation;
        Vec3i min = this.center.subtract(extra, 0, extra);
        Vec3i max = this.center.add(extra, 0, extra);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public double getDistanceSq(Vec3d pos) {
        return pos.distanceSq(this.center);
    }

    public boolean morph(Tile tile, Random rand) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int extra = this.influence + this.variation;
        int xMin = this.center.x - extra - origin.x;
        int zMin = this.center.z - extra - origin.z;
        int xMax = this.center.x + extra - origin.x;
        int zMax = this.center.z + extra - origin.z;
        xMin = Math.max(0, xMin);
        zMin = Math.max(0, zMin);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        int xCenter = this.center.x - origin.x;
        int zCenter = this.center.z - origin.z;
        int yWater = this.center.y;
        int yCenter = this.center.y - 1;
        int yCenterBottom = this.center.y - this.depth;
        int radiusSq = this.radius * this.radius;
        int influenceRadiusSq = this.influence * this.influence;
        int carveRadiusSq = this.carveRadius * this.carveRadius;
        int carveInfluenceSq = this.carveInfluence * this.carveInfluence;
        int maxCarveInfluenceSq = Math.max(carveInfluenceSq, radiusSq);
        int shoreWidth = Math.min(this.radius, this.depth * 2);
        int carveThreshold = this.getCarveElevation();
        log.info("applying:" + this);
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                byte fluidType;
                int delta;
                int y;
                double dx = x * spread - xCenter;
                double dz = z * spread - zCenter;
                if (USE_OFFSET_FRACTALS) {
                    double xDelta = X_OFFSET.getSample((double)x, (double)this.center.y, (double)z) * HALF_INV_SQRT2;
                    double zDelta = Z_OFFSET.getSample((double)x, (double)this.center.y, (double)z) * HALF_INV_SQRT2;
                    dx = (int)Math.round(dx + xDelta * (double)this.variation);
                    dz = (int)Math.round(dz + zDelta * (double)this.variation);
                }
                double dSq = dx * dx + dz * dz;
                int yNew = y = terrain.getElevation(x, z);
                int yDesired = y;
                boolean wet = false;
                if (dSq <= (double)radiusSq) {
                    double edgeDistance = (double)this.radius - Math.sqrt(dSq);
                    double ratio = Math.min(1.0, edgeDistance / (double)shoreWidth);
                    ratio = FractalUtils.smoothStep((double)0.0, (double)1.0, (double)ratio);
                    yDesired = (int)FractalUtils.mix((double)yWater, (double)(yWater - this.depth), (double)ratio);
                    wet = true;
                    if (USE_DEPTH_FRACTAL) {
                        double depthFactor = DEPTH_OFFSET.getSample((double)x, (double)this.center.y, (double)z) * HALF_INV_SQRT2;
                        double depthDelta = (double)(y - yDesired) / (double)this.depth;
                        yDesired = (int)((double)yDesired + depthFactor * depthDelta * 0.5);
                    }
                } else if (dSq < (double)influenceRadiusSq) {
                    double ratio = (dSq - (double)radiusSq) / (double)(influenceRadiusSq - radiusSq);
                    yDesired = (int)Math.round(FractalUtils.mix((double)yWater, (double)y, (double)ratio));
                }
                yNew = yDesired;
                if (USE_TERRAIN_INFLUENCE && dSq < (double)influenceRadiusSq && (delta = y - this.carveElevation) > 0) {
                    double ratio = dSq * 2.0 / (double)influenceRadiusSq;
                    ratio = Math.min(1.0, ratio);
                    double ratio2 = (double)delta / 10.0;
                    ratio2 = Math.min(1.0, ratio2);
                    yNew = (int)Math.round(FractalUtils.mix((double)yNew, (double)y, (double)(ratio * ratio2)));
                }
                if (y == yNew && !wet || (fluidType = fluid.getType(x, z)) != -1) continue;
                terrain.setElevation(x, z, (short)yNew);
                if (yNew > yCenter || !wet) continue;
                terrain.setType(x, z, (byte)1);
                fluid.setElevation(x, z, (short)this.center.y);
                fluid.setType(x, z, (byte)1);
            }
        }
        return false;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)((Object)((Object)this)).getClass().getSimpleName()).add("type", this.type).add("center", (Object)this.center).add("depth", this.depth).add("radius", this.radius).add("influence", this.influence).add("carveElevation", this.carveElevation).add("carveRadius", this.carveRadius).add("carveInfluence", this.carveInfluence).add("variation", this.variation).toString();
    }
}

