/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import java.util.Objects;

public class ObjectState
implements Cloneable {
    public static long NO_PARENT = -1L;
    public int networkId;
    public int zoneId;
    public Long realId;
    public Long parentId;
    public long positionBits;
    public long rotationBits;

    public ObjectState() {
        this(0, null);
    }

    public ObjectState(int networkId) {
        this(networkId, null);
    }

    public ObjectState(int networkId, Long realId) {
        this.networkId = networkId;
        this.realId = realId;
        this.zoneId = -1;
        this.positionBits = -1L;
        this.rotationBits = -1L;
    }

    public ObjectState clone() {
        try {
            return (ObjectState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public void set(ObjectState state) {
        this.networkId = state.networkId;
        this.zoneId = state.zoneId;
        this.realId = state.realId;
        this.parentId = state.parentId;
        this.positionBits = state.positionBits;
        this.rotationBits = state.rotationBits;
    }

    public boolean isMarkedRemoved() {
        return this.zoneId == 0;
    }

    public void markRemoved() {
        this.zoneId = 0;
    }

    public ObjectState getDelta(ObjectState baseline) {
        if (baseline == null) {
            return this.clone();
        }
        ObjectState result = new ObjectState(this.networkId);
        if (this.zoneId != baseline.zoneId) {
            result.zoneId = this.zoneId;
        }
        if (!Objects.equals(this.realId, baseline.realId)) {
            result.realId = this.realId;
        }
        if (!Objects.equals(this.parentId, baseline.parentId)) {
            result.parentId = this.parentId;
        }
        if (this.positionBits != baseline.positionBits) {
            result.positionBits = this.positionBits;
        }
        if (this.rotationBits != baseline.rotationBits) {
            result.rotationBits = this.rotationBits;
        }
        return result;
    }

    public void applyDelta(ObjectState delta) {
        if (delta.zoneId != -1) {
            this.zoneId = delta.zoneId;
        }
        if (delta.parentId != null) {
            this.parentId = delta.parentId;
        }
        if (delta.positionBits != -1L) {
            this.positionBits = delta.positionBits;
        }
        if (delta.rotationBits != -1L) {
            this.rotationBits = delta.rotationBits;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[id=").append(this.networkId);
        if (this.realId != null) {
            sb.append(", realId=").append(this.realId);
        }
        if (this.parentId != null) {
            sb.append(", parentId=").append(this.parentId);
        }
        if (this.zoneId == 0 && this.parentId == null) {
            sb.append(", REMOVED");
        } else if (this.zoneId != -1) {
            sb.append(", zoneId=").append(this.zoneId);
        }
        if (this.positionBits != -1L) {
            sb.append(", positionBits=").append(Long.toHexString(this.positionBits));
        }
        if (this.rotationBits != -1L) {
            sb.append(", rotationBits=").append(Long.toHexString(this.rotationBits));
        }
        sb.append("]");
        return sb.toString();
    }
}

