/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityContainer<T> {
    static Logger log = LoggerFactory.getLogger(EntityContainer.class);
    private EntityData ed;
    private EntityCriteria criteria;
    private EntitySet entities;
    private T[] array;
    private Map<EntityId, T> objects = new HashMap<EntityId, T>();
    private Class parameter;

    @SafeVarargs
    protected EntityContainer(EntityData ed, Class<? extends EntityComponent> ... componentTypes) {
        this(ed, (ComponentFilter)null, componentTypes);
    }

    @SafeVarargs
    protected EntityContainer(EntityData ed, ComponentFilter filter, Class<? extends EntityComponent> ... componentTypes) {
        this(ed, new EntityCriteria().set(filter, (Class[])componentTypes));
    }

    protected EntityContainer(EntityData ed, EntityCriteria criteria) {
        this.ed = ed;
        this.criteria = criteria;
        this.parameter = EntityContainer.findParameterType(this.getClass(), new HashMap<String, Type>());
        if (this.parameter == null) {
            this.parameter = Object.class;
            log.warn("Element parameter type not found for:" + this.getClass() + "  Using Object.class.");
        }
    }

    private static Class findParameterType(Class c, Map<String, Type> parameterMap) {
        if (log.isTraceEnabled()) {
            log.trace("findParameterType(" + c + ") parameters:" + Arrays.asList(c.getTypeParameters()));
        }
        Type t = c;
        while (t != null) {
            if (log.isTraceEnabled()) {
                log.trace("  checking:" + t);
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Class rawType = (Class)pt.getRawType();
                Type[] types = pt.getActualTypeArguments();
                TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
                for (int i = 0; i < types.length; ++i) {
                    if (log.isTraceEnabled()) {
                        log.trace("    " + vars[i] + " = " + types[i] + "  class:" + types[i].getClass());
                    }
                    if (!(types[i] instanceof Class)) continue;
                    parameterMap.put(vars[i].getName(), types[i]);
                }
                if (pt.getRawType() == EntityContainer.class) {
                    Type result;
                    if (pt.getActualTypeArguments()[0] instanceof ParameterizedType) {
                        return (Class)((ParameterizedType)pt.getActualTypeArguments()[0]).getRawType();
                    }
                    Type arg = pt.getActualTypeArguments()[0];
                    if (arg instanceof Class) {
                        return (Class)arg;
                    }
                    if (arg instanceof TypeVariable && (result = parameterMap.get(((TypeVariable)arg).getName())) != null) {
                        return (Class)result;
                    }
                    log.warn("Unhandled arg type:" + arg);
                }
            }
            if (t instanceof Class) {
                if (log.isTraceEnabled()) {
                    log.trace("    class type parameters:" + Arrays.asList(((Class)t).getTypeParameters()));
                }
                t = ((Class)t).getGenericSuperclass();
                continue;
            }
            t = null;
        }
        Class superClass = c.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return EntityContainer.findParameterType(superClass, parameterMap);
        }
        return null;
    }

    protected void setFilter(ComponentFilter filter) {
        int count = 0;
        boolean found = false;
        for (ComponentFilter f : this.criteria.getFilters()) {
            if (f == null) continue;
            if (filter == f) {
                found = true;
            }
            ++count;
        }
        if (count == 1 && found) {
            return;
        }
        this.criteria.clearFilters();
        this.criteria.setFilter(filter.getComponentType(), filter);
        if (this.entities != null) {
            this.entities.resetEntityCriteria(this.criteria);
        }
    }

    protected void setCriteria(EntityCriteria criteria) {
        this.criteria = criteria;
        if (this.entities != null) {
            this.entities.resetEntityCriteria(criteria);
        }
    }

    protected EntityCriteria getCriteria() {
        return this.criteria;
    }

    protected EntityData getEntityData() {
        return this.ed;
    }

    protected void addComponentTypes(Class<? extends EntityComponent> ... add) {
        this.criteria.add((Class[])add);
    }

    public int size() {
        return this.entities.size();
    }

    public T getObject(EntityId id) {
        return this.objects.get(id);
    }

    protected Set<Class<? extends EntityComponent>> getComponentTypes() {
        return this.criteria.getComponentTypes();
    }

    protected T[] getArray() {
        if (this.array != null) {
            return this.array;
        }
        this.array = (Object[])Array.newInstance(this.parameter, this.objects.size());
        this.array = this.objects.values().toArray(this.array);
        return this.array;
    }

    protected abstract T addObject(Entity var1);

    protected abstract void updateObject(T var1, Entity var2);

    protected abstract void removeObject(T var1, Entity var2);

    protected void addObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.addObject(e);
            this.objects.put(e.getId(), object);
        }
        this.array = null;
    }

    protected void updateObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.objects.get(e.getId());
            if (object == null) {
                log.warn("Update: No matching object for entity:" + e);
                continue;
            }
            this.updateObject(object, e);
        }
    }

    protected void removeObjects(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            T object = this.objects.remove(e.getId());
            if (object == null) {
                log.warn("Remove: No matching object for entity:" + e);
                continue;
            }
            this.removeObject(object, e);
        }
        this.array = null;
    }

    public void start() {
        this.entities = this.ed.getEntities(this.criteria);
        this.entities.applyChanges();
        this.addObjects((Set<Entity>)this.entities);
    }

    public boolean update() {
        if (this.entities.applyChanges()) {
            this.removeObjects(this.entities.getRemovedEntities());
            this.addObjects(this.entities.getAddedEntities());
            this.updateObjects(this.entities.getChangedEntities());
            return true;
        }
        return false;
    }

    public void stop() {
        if (this.entities == null) {
            return;
        }
        this.removeObjects((Set<Entity>)this.entities);
        this.entities.release();
        this.entities = null;
    }

    public boolean isStarted() {
        return this.entities != null;
    }

    public String toString() {
        return this.getClass().getName() + "[components=" + this.criteria.getComponentTypes() + "]";
    }
}

