/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import mythruna.character.ClothingTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingTemplateIndex {
    public static final String CLOTHING_TEMPLATE_INDEX_JSON = "clothing/clothing-templates.json";
    static Logger log = LoggerFactory.getLogger(ClothingTemplateIndex.class);
    private List<ClothingTemplate> templates = new ArrayList<ClothingTemplate>();
    private transient Map<String, ClothingTemplate> index = new TreeMap<String, ClothingTemplate>();

    protected ClothingTemplateIndex() {
    }

    protected void upgrade() {
        for (ClothingTemplate template : this.templates) {
            this.index.put(template.getName(), template);
        }
    }

    public List<ClothingTemplate> getTemplates() {
        return this.templates;
    }

    public Map<String, ClothingTemplate> getIndex() {
        return this.index;
    }

    public void expand() {
        for (ClothingTemplate template : this.templates) {
            template.expand();
        }
    }

    public ClothingTemplate getTemplate(String name) {
        return this.index.get(name);
    }

    public static ClothingTemplateIndex initialize(List<ClothingTemplate> templates) {
        ClothingTemplateIndex result = new ClothingTemplateIndex();
        result.templates = templates;
        result.upgrade();
        return result;
    }

    public static ClothingTemplateIndex create(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        ClothingTemplateIndex result = (ClothingTemplateIndex)gson.fromJson(json, ClothingTemplateIndex.class);
        result.upgrade();
        return result;
    }

    public static ClothingTemplateIndex create(Function<String, String> textFunc) {
        return ClothingTemplateIndex.create(textFunc.apply(CLOTHING_TEMPLATE_INDEX_JSON));
    }

    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        return gson.toJson((Object)this);
    }
}

