/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.simsilica.mblock.CellArray;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricUtils {
    static Logger log = LoggerFactory.getLogger(FabricUtils.class);

    public static int toCell(int shape, int fabric) {
        return shape << 16 | fabric & 0xFFFF;
    }

    public static int toShape(int value) {
        return value >> 16 & 0xFFFF;
    }

    public static int toFabric(int value) {
        return value & 0xFFFF;
    }

    public static CellArray remap(CellArray source, Map<Integer, Integer> remap) {
        CellArray result = source.clone();
        int xSize = source.getSizeX();
        int ySize = source.getSizeY();
        int zSize = source.getSizeZ();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                int val;
                for (int z = 0; z < zSize && (val = source.getCell(x, y, z)) != 0; ++z) {
                    int fab = FabricUtils.toFabric(val);
                    Integer r = remap.get(fab);
                    if (r == null) continue;
                    int shape = FabricUtils.toShape(val);
                    val = FabricUtils.toCell(shape, r);
                    result.setCell(x, y, z, val);
                }
            }
        }
        return result;
    }
}

