/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.es.AttachedTo;
import mythruna.es.ContainedIn;
import mythruna.es.Holding;
import mythruna.sim.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoldingSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(HoldingSystem.class);
    private EntityData ed;
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;
    private EntityChangeObserver entityListener = new EntityChangeObserver();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.objectTypes = (ObjectTypeRegistry)this.getSystem(ObjectTypeRegistry.class);
    }

    protected void terminate() {
    }

    public void start() {
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    public void update(SimTime time) {
        EntityChange change = null;
        while ((change = this.changes.poll()) != null) {
            Holding holding = (Holding)change.getComponent();
            this.updateHolding(change.getEntityId(), holding);
        }
    }

    public void stop() {
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    protected EntityId cleanupHolding(EntityId entityId) {
        log.info("cleanHolding(" + entityId + ")");
        EntityId item = this.ed.findEntity(AttachedTo.filter(entityId, "hand.right", this.ed), new Class[0]);
        if (item == null) {
            return item;
        }
        this.ed.removeComponent(item, AttachedTo.class);
        ContainedIn in = (ContainedIn)this.ed.getComponent(item, ContainedIn.class);
        if (in == null) {
            log.error("Unheld/detached entity has no container and will disappear:" + item);
        }
        return item;
    }

    protected void updateHolding(EntityId entityId, Holding holding) {
        Quatd handleRot;
        Vec3d handlePos;
        log.info("updateHolding(" + entityId + ", " + holding + ")");
        EntityId oldItem = this.cleanupHolding(entityId);
        if (holding == null || holding.getTarget() == null) {
            return;
        }
        EntityId actor = entityId;
        EntityId item = holding.getTarget();
        ObjectType type = this.objectTypes.getType((Object)item);
        if (type == null) {
            handlePos = new Vec3d();
            handleRot = new Quatd();
        } else {
            handlePos = (Vec3d)type.getTypeVar("handleLocation", (Object)new Vec3d());
            handleRot = (Quatd)type.getTypeVar("handleRotation", (Object)new Quatd());
        }
        Quatd rot = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0);
        ShapeInfo shape = (ShapeInfo)this.ed.getComponent(item, ShapeInfo.class);
        double itemScale = 1.0;
        if (shape != null) {
            itemScale = shape.getScale();
        }
        rot = rot.mult(handleRot);
        handlePos = handlePos.mult(-itemScale);
        rot.mult(handlePos, handlePos);
        this.ed.setComponents(item, new EntityComponent[]{AttachedTo.create(actor, "hand.right", handlePos, rot, this.ed)});
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != Holding.class) {
                return;
            }
            HoldingSystem.this.changes.add(change);
        }
    }
}

