/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.db.CellArrayId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.character.CharacterDecorator;
import mythruna.fabric.ClothingPainter;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.FabricType;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(ClothingDecorator.class);
    private AssetManager assets;
    private Function<CellArrayId, CellArray> cellStorage;
    private Spatial spatial;
    private List<Material> baseMaterials = new ArrayList<Material>();
    private List<Material> accMaterials = new ArrayList<Material>();
    private List<Spatial> hats = new ArrayList<Spatial>();
    private List<Spatial> masks = new ArrayList<Spatial>();
    private ShapeName name;
    private String modelPath;
    private ShapeName colorName;
    private FabricType clearBase;
    private FabricType transparentBase;
    private ShapeName fabName;
    private CellArray cells;
    private volatile boolean needsApply;
    private ShapeName accName;
    private CellArray accCells;

    public ClothingDecorator(AssetManager assets, Function<CellArrayId, CellArray> cellStorage) {
        this.assets = assets;
        this.cellStorage = cellStorage;
        this.transparentBase = new FabricType("transparent", "transparent").diffuse(new FabricTexture(new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f)));
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (this.spatial == spatial) {
            return;
        }
        this.spatial = spatial;
        this.baseMaterials.clear();
        spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                if (log.isTraceEnabled()) {
                    log.trace("geom:" + geom + "  material:" + mat);
                }
                String matDefName = mat.getMaterialDef().getAssetName();
                String matName = mat.getName();
                if ("SkinGrid".equals(matName)) {
                    ClothingDecorator.this.baseMaterials.add(mat);
                } else if ("Hat".equals(matName)) {
                    ClothingDecorator.this.hats.add((Spatial)geom);
                    ClothingDecorator.this.accMaterials.add(mat);
                } else if ("Mask".equals(matName)) {
                    ClothingDecorator.this.masks.add((Spatial)geom);
                    ClothingDecorator.this.accMaterials.add(mat);
                }
            }
        });
        this.needsApply = true;
    }

    @Override
    public void setShapeName(ShapeName name) {
        ShapeName fabName;
        if (Objects.equals(this.name, name)) {
            return;
        }
        this.name = name;
        String modelPath = name.getName();
        int split = modelPath.lastIndexOf("/");
        if (split >= 0) {
            modelPath = modelPath.substring(0, split);
        }
        if ((fabName = this.find("fab", name)) != null) {
            this.setColorName(this.find("sc", name), modelPath);
            this.setFabName(fabName);
            this.setAccName(this.find("acc", name));
        } else {
            this.setColorName(null, null);
            this.setFabName(null);
            this.setAccName(null);
        }
    }

    protected void setColorName(ShapeName colorName, String modelPath) {
        if (Objects.equals(this.colorName, colorName) && Objects.equals(this.modelPath, modelPath)) {
            return;
        }
        this.colorName = colorName;
        this.modelPath = modelPath;
        if (log.isTraceEnabled()) {
            log.trace("************ shape path:" + modelPath);
        }
        if (colorName != null) {
            int colorArgb = (int)Long.parseUnsignedLong(colorName.getName(), 16);
            ColorRGBA color = new ColorRGBA().fromIntARGB(colorArgb |= 0xFF000000);
            if (log.isTraceEnabled()) {
                log.trace("Skin color:" + color);
            }
            this.clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture(modelPath + "/BaseSkin.png", color)).specular(new FabricTexture(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f)));
        } else {
            this.clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture(modelPath + "/BaseSkin.png")).specular(new FabricTexture(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f)));
        }
        this.clearBase.initialize(this.assets);
        this.needsApply = true;
    }

    protected void setFabName(ShapeName fabName) {
        if (log.isTraceEnabled()) {
            log.trace("setFabName(" + fabName + ")");
        }
        if (this.cells != null && Objects.equals(this.fabName, fabName)) {
            return;
        }
        this.fabName = fabName;
        if (fabName != null) {
            CellArrayId id = CellArrayId.fromString((String)fabName.getName());
            if (log.isTraceEnabled()) {
                log.trace("loading clothing cell array:" + id);
            }
            this.cells = this.cellStorage.apply(id);
            if (log.isTraceEnabled()) {
                log.trace("read cells:" + this.cells);
            }
        } else {
            this.cells = null;
        }
        this.needsApply = true;
    }

    protected void setAccName(ShapeName accName) {
        if (log.isTraceEnabled()) {
            log.trace("setAccName(" + accName + ")");
        }
        if (this.accCells != null && Objects.equals(this.accName, accName)) {
            return;
        }
        this.accName = accName;
        if (accName != null) {
            CellArrayId id = CellArrayId.fromString((String)accName.getName());
            if (log.isTraceEnabled()) {
                log.trace("loading acc cell array:" + id);
            }
            this.accCells = this.cellStorage.apply(id);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("no accessories");
            }
            this.accCells = null;
        }
        if (log.isTraceEnabled()) {
            log.trace(" cells:" + this.accCells);
        }
        this.needsApply = true;
    }

    @Override
    public boolean apply() {
        if (!this.needsApply) {
            return false;
        }
        boolean result = false;
        if (log.isTraceEnabled()) {
            log.trace("apply() cells:" + this.cells + "  clearBase:" + this.clearBase);
        }
        if (this.cells == null) {
            if (log.isTraceEnabled()) {
                log.trace("cells is null for:" + this.spatial + " with shape name:" + this.name);
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("apply() skinColor:" + this.colorName + " fab:" + this.fabName);
            }
            result = true;
            ClothingPainter painter = new ClothingPainter();
            painter.repaint((CellData)this.cells, this.clearBase);
            this.applyMaterials(painter, this.baseMaterials);
        }
        boolean maskVisible = false;
        boolean hatVisible = false;
        if (this.accCells != null) {
            ClothingPainter painter2 = new ClothingPainter(true);
            if (painter2.repaint((CellData)this.accCells, this.transparentBase)) {
                maskVisible = true;
                hatVisible = true;
            }
            this.applyMaterials(painter2, this.accMaterials);
            result = true;
        }
        for (Spatial s : this.hats) {
            if (log.isTraceEnabled()) {
                log.trace("s:" + s + " visible:" + hatVisible);
            }
            s.setCullHint(hatVisible ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }
        for (Spatial s : this.masks) {
            if (log.isTraceEnabled()) {
                log.trace("s:" + s + " visible:" + maskVisible);
            }
            s.setCullHint(maskVisible ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }
        this.needsApply = false;
        return true;
    }

    protected void applyMaterials(ClothingPainter painter, List<Material> materials) {
        for (Material mat : materials) {
            if (log.isTraceEnabled()) {
                log.trace("Applying clothing to:" + mat);
            }
            mat.setTexture("DiffuseMap", painter.getDiffuseTexture());
            mat.setTexture("NormalMap", painter.getNormalTexture());
            mat.setTexture("SpecularMap", painter.getSpecularTexture());
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", ColorRGBA.White);
            mat.setColor("Ambient", ColorRGBA.White);
            mat.setColor("Specular", ColorRGBA.White);
            mat.setFloat("Shininess", 512.0f);
        }
    }

    protected ShapeName find(String type, ShapeName name) {
        if (type.equals(name.getType())) {
            return name;
        }
        for (ShapeName sub : name.getAddOns()) {
            if (!type.equals(sub.getType())) continue;
            return sub;
        }
        return null;
    }
}

