/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.dnd.DefaultDraggable;
import com.simsilica.lemur.dnd.DragStatus;
import mythruna.client.ui.item.ItemBorder;
import mythruna.client.ui.item.ItemView;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDraggable
extends DefaultDraggable {
    static Logger log = LoggerFactory.getLogger(ItemDraggable.class);
    private static ColorRGBA PENDING_COLOR = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.7f);
    private static ColorRGBA INVALID_COLOR = new ColorRGBA(0.4f, 0.1f, 0.1f, 0.5f);
    private static ColorRGBA NULL_COLOR = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private ItemView itemView;
    private ItemBorder border;

    public ItemDraggable(ViewPort view, ItemView itemView, Vector2f start) {
        super(view, (Spatial)itemView, start);
        this.itemView = itemView;
        InventorySize2d size = itemView.getItem().getItemSize();
        this.border = new ItemBorder(size.getXSlots(), size.getYSlots());
    }

    public ItemView getItemView() {
        return this.itemView;
    }

    public ItemBorder getBorder() {
        return this.border;
    }

    public void updateDragStatus(DragStatus status) {
        log.info("updateDragStatus(" + status + ")");
        switch (status) {
            case InvalidTarget: {
                this.border.setColor(INVALID_COLOR);
                break;
            }
            case ValidTarget: {
                this.border.setColor(PENDING_COLOR);
                break;
            }
            default: {
                this.border.setColor(NULL_COLOR);
            }
        }
    }

    public void release() {
        this.border.setParentGrid(null);
    }
}

