uniform float g_Time;

#define USE_NOISE 1

//#ifndef TIME_BIAS
//#define TIME_BIAS 0.0
//#endif

//#define DEBUG 1

uniform sampler2D m_AtlasMap;
uniform sampler2D m_Noise;
uniform vec4 m_RootGlowColor;

varying vec2 texCoord;

varying float cell1;
varying float cell2;
varying float cell3;
varying float offset1;
varying float offset2;
varying float offset3;



vec2 textureNoise( in vec2 texCoord, in float time ) {
    vec2 result = texCoord;
    result.x = result.x;
    vec2 noiseCoord = result;

    noiseCoord.y = noiseCoord.y - time;

    vec4 noise = texture2D(m_Noise, noiseCoord);
    result.x += noise.r * 0.2 - 0.1;

    noiseCoord.x = noiseCoord.x + (time*0.8);
    noise = texture2D(m_Noise, noiseCoord);
    result.y += noise.r * 0.1 - 0.05;

    return result;
}


float calculateAlpha( in float offset )
{
    float d = offset * 2.0 - 1.0;
    return 1.0 - (d * d);
}


void main(){

    vec2 tc = texCoord;
    tc.y = 1.0 - ((1.0 - tc.y) * (1.0 - tc.y));


    // Calculate values for texture 1
    //float atlasCell = 0.0;
    float atlasCell = cell1; //mod( floor(g_Time+TIME_BIAS), float(ATLAS_CELL_COUNT) );
    #ifdef USE_NOISE
    vec2 noiseCoord = textureNoise( tc, (g_Time+TIME_BIAS) * ANIMATION_SPEED );
    #else
    vec2 noiseCoord = tc;
    #endif

    noiseCoord.y -= (offset1 * offset1) * FLY_LENGTH;
    noiseCoord.x = noiseCoord.x * ATLAS_CELL_SIZE + atlasCell * ATLAS_CELL_SIZE;
    vec4 texel = texture2D( m_AtlasMap, noiseCoord );

    #ifdef DEBUG
    //texel *= vec4(1.0,0.0,0.0,1.0);
    texel = vec4(1.0,0.0,0.0,1.0);
    #endif

    float alpha1 = clamp(calculateAlpha(offset1) * 1.0, 0.0, 1.0);
    alpha1 *= clamp(tc.y * tc.y * 4.0, 0.0, 1.0);



    // Calculate values for texture 2
    atlasCell = cell2; //mod(atlasCell + 1.0, float(ATLAS_CELL_COUNT));
    #ifdef USE_NOISE
    noiseCoord = textureNoise( tc, (g_Time+TIME_BIAS) * ANIMATION_SPEED * 0.9 );
    #else
    noiseCoord = tc;
    #endif

    noiseCoord.y -= (offset2 * offset2) * FLY_LENGTH;
    noiseCoord.x = noiseCoord.x * ATLAS_CELL_SIZE + atlasCell * ATLAS_CELL_SIZE;
    vec4 texel2 = texture2D( m_AtlasMap, noiseCoord );

    #ifdef DEBUG
    //texel2 *= vec4(0.0,1.0,0.0,1.0);
    texel2 = vec4(0.0,1.0,0.0,1.0);
    #endif

    float alpha2 = clamp(calculateAlpha(offset2) * 1.0, 0.0, 1.0);
    alpha2 *= clamp(tc.y * tc.y * 4.0, 0.0, 1.0);


    // Calculate values for texture 3
    atlasCell = cell3; //mod(atlasCell + 1.0, float(ATLAS_CELL_COUNT));
    #ifdef USE_NOISE
    noiseCoord = textureNoise( tc, (g_Time+TIME_BIAS) * ANIMATION_SPEED * 0.7 );
    #else
    noiseCoord = tc;
    #endif

    noiseCoord.y -= (offset3 * offset3) * FLY_LENGTH;
    noiseCoord.x = noiseCoord.x * ATLAS_CELL_SIZE + atlasCell * ATLAS_CELL_SIZE;
    vec4 texel3 = texture2D( m_AtlasMap, noiseCoord );

    #ifdef DEBUG
    //texel3 *= vec4(0.0,0.0,1.0,1.0);
    texel3 = vec4(0.0,0.0,1.0,1.0);
    #endif

    float alpha3 = clamp(calculateAlpha(offset3) * 1.0, 0.0, 1.0);
    alpha3 *= clamp(tc.y * tc.y * 4.0, 0.0, 1.0);

    #ifdef BLEND_ADD
    // Regular add blending
    vec4 color = texel * alpha1 + texel2 * alpha2 + texel3 * alpha3;
    #else
    // Pure mix blending (dark and ugly)
    //color = mix(texel * alpha1, texel2 * alpha2, 0.5);
    //color = mix(color, texel3 * alpha3, 0.5);

    // A weighted averaging
    vec4 color = texel * alpha1 + texel2 * alpha2 + texel3 * alpha3;
    color *= 1.0/(alpha1 + alpha2 + alpha3);
    #endif

    // Accumulated alpha value
    color.a = color.r + color.g + color.b;

    // Fade at the edges
    float xOffset = -1.0 + tc.x * 2.0;
    float fade = (1.0 - (xOffset * xOffset)) * (1.0 - tc.y);
    color.a = color.a * fade;

    #ifdef ROOT_GLOW
    float xDiff = clamp((tc.x - 0.5) * 3.0, -1.0, 1.0);
    float yDiff = clamp((tc.y - 0.5) * 2.0, -1.0, 1.0);
    float fade2 = clamp(1.0 - (xDiff * xDiff + yDiff * yDiff), 0.0, 1.0);

    color += fade2 * m_RootGlowColor;

    // Setting the fade directly creates a more fake looking fire that
    // might be worth pursuing for a "painterly" look
    //color.a = fade2 * 0.5;
    #endif

    if( color.a < 0.01 )
        discard;

    gl_FragColor = color;
}
