/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.Objects;

public class MovementInput
implements EntityComponent {
    public static final byte NONE = 0;
    public static final byte JUMP = 1;
    public static final byte DRAG1 = 2;
    public static final byte DRAG2 = 4;
    private Vec3d move;
    private Quatd facing;
    private byte flags;

    private MovementInput() {
    }

    public MovementInput(Vec3d move, Quatd facing, byte flags) {
        this.move = move;
        this.facing = facing;
        this.flags = flags;
    }

    public MovementInput changeFacing(Quatd facing) {
        return new MovementInput(this.move, facing, this.flags);
    }

    public Vec3d getMove() {
        return this.move;
    }

    public Quatd getFacing() {
        return this.facing;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isJumping() {
        return (this.flags & 1) != 0;
    }

    public boolean isDrag1() {
        return (this.flags & 2) != 0;
    }

    public boolean isDrag2() {
        return (this.flags & 4) != 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MovementInput other = (MovementInput)o;
        if (other.flags != this.flags) {
            return false;
        }
        if (!Objects.equals(other.move, this.move)) {
            return false;
        }
        return Objects.equals(other.facing, this.facing);
    }

    public int hashCode() {
        return Objects.hash(this.move, this.facing, this.flags);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("move", (Object)this.move).add("facing", (Object)this.facing).add("flags", (Object)Integer.toBinaryString(this.flags)).toString();
    }
}

