/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.time;

import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.Tween;
import java.util.function.Supplier;
import mythruna.sim.time.TimeInterval;
import mythruna.sim.time.TweenFactory;
import mythruna.sim.time.TweenSchedule;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledSupplier
implements Supplier<Double> {
    static Logger log = LoggerFactory.getLogger(ScheduledSupplier.class);
    private WorldTime time;
    private TweenSchedule<Double> schedule;
    private double volume;

    public ScheduledSupplier(WorldTime time, TimeInterval baseInterval) {
        this.time = time;
        this.schedule = new TweenSchedule<Double>(baseInterval, new VolumeTweenFactory());
    }

    @Override
    public Double get() {
        this.schedule.accept(this.time);
        return this.volume;
    }

    public ScheduledSupplier at(String time, Double value) {
        return this.at(TimeInterval.parseInterval(time), value);
    }

    public ScheduledSupplier at(TimeInterval time, Double value) {
        this.schedule.at(time, value);
        return this;
    }

    private class VolumeTweenFactory
    implements TweenFactory<Double> {
        private VolumeTweenFactory() {
        }

        @Override
        public Tween createTween(double length, final Double start, final Double end) {
            return new AbstractTween(length){

                public void doInterpolate(double t) {
                    ScheduledSupplier.this.volume = start + (end - start) * t;
                }
            };
        }
    }
}

