/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.list;

import com.google.common.base.Function;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.list.CellRenderer;
import com.simsilica.lemur.style.ElementId;

public class DefaultCellRenderer<T>
implements CellRenderer<T>,
Cloneable {
    private String style;
    private ElementId elementId;
    private Function<T, String> transform;

    public DefaultCellRenderer() {
        this(new ElementId("button"), null, null);
    }

    public DefaultCellRenderer(String style) {
        this(new ElementId("button"), style, null);
    }

    public DefaultCellRenderer(ElementId elementId, String style) {
        this(elementId, style, null);
    }

    public DefaultCellRenderer(ElementId elementId, String style, Function<T, String> transform) {
        this.style = style;
        this.elementId = elementId;
        this.transform = transform;
    }

    public DefaultCellRenderer<T> clone() {
        try {
            return (DefaultCellRenderer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void configureStyle(ElementId elementId, String style) {
        if (this.elementId == null) {
            this.elementId = elementId;
        }
        if (this.style == null) {
            this.style = style;
        }
    }

    public void setTransform(Function<T, String> transform) {
        this.transform = transform;
    }

    public Function<T, String> getTransform() {
        return this.transform;
    }

    @Deprecated
    public ElementId getElement() {
        return this.elementId;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public String getStyle() {
        return this.style;
    }

    protected String valueToString(T value) {
        if (this.transform != null) {
            return (String)this.transform.apply(value);
        }
        return String.valueOf(value);
    }

    @Override
    public Panel getView(T value, boolean selected, Panel existing) {
        if (existing == null) {
            existing = new Button(this.valueToString(value), this.elementId, this.style);
        } else {
            ((Button)existing).setText(this.valueToString(value));
        }
        return existing;
    }
}

