/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.es.EntityId;
import com.simsilica.es.StringIndex;
import com.simsilica.es.client.EntityDataClientService;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mworld.io.CellArrayProtocol;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.assembly.io.SubassemblyProtocol;
import mythruna.es.MovementInput;
import mythruna.net.AssemblyBlueprintData;
import mythruna.net.BlueprintData;
import mythruna.net.ClothingData;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionClientService
extends AbstractClientService
implements GameSession {
    static Logger log = LoggerFactory.getLogger(GameSessionClientService.class);
    private RmiClientService rmiService;
    private GameSession delegate;
    private GameSessionCallback sessionCallback = new GameSessionCallback();
    private List<GameSessionListener> listeners = new CopyOnWriteArrayList<GameSessionListener>();
    private StringIndex strings;
    private LoadingCache<CellArrayId, CellArray> cellArrayCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<CellArrayId, CellArray>(){

        public CellArray load(CellArrayId key) {
            GameSessionClientService.this.threadCheck();
            byte[] bytes = GameSessionClientService.this.getCellArrayBytes(key.getId());
            return CellArrayProtocol.fromBytes((byte[])bytes);
        }
    });
    private volatile EntityId avatar;

    protected void threadCheck() {
        if ("jME3 Main".equals(Thread.currentThread().getName())) {
            log.warn("long-style query, cache miss on render thread", new Throwable("stack-trace"));
        }
    }

    @Override
    public EntityId getCharacter() {
        this.threadCheck();
        return this.getDelegate().getCharacter();
    }

    @Override
    public EntityId getAvatar() {
        if (this.avatar == null) {
            this.threadCheck();
            this.avatar = this.getDelegate().getAvatar();
        }
        return this.avatar;
    }

    @Override
    public void setMovementInput(MovementInput input) {
        this.getDelegate().setMovementInput(input);
    }

    @Override
    public void executeShell(String cmd) {
        this.getDelegate().executeShell(cmd);
    }

    @Override
    public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
        this.getDelegate().executeCommand(cmdId, subject, parms);
    }

    @Override
    public void executeCommand(String cmd, EntityId subject, Object ... parms) {
        int id = this.strings.getStringId(cmd, false);
        if (id < 0) {
            throw new IllegalArgumentException("No command defined:" + cmd);
        }
        this.executeCommand(id, subject, parms);
    }

    @Override
    public void runAction(EntityId target, int actionId, Object ... parms) {
        this.getDelegate().runAction(target, actionId, parms);
    }

    @Override
    public void runAction(EntityId target, String actionName, Object ... parms) {
        int id = this.strings.getStringId(actionName, false);
        if (id < 0) {
            throw new IllegalArgumentException("No action ID defined for:" + actionName);
        }
        this.runAction(target, id, parms);
    }

    @Override
    public void runActionIfExists(EntityId target, int actionId, Object ... parms) {
        this.getDelegate().runActionIfExists(target, actionId, parms);
    }

    @Override
    public void runActionIfExists(EntityId target, String actionName, Object ... parms) {
        int id = this.strings.getStringId(actionName, false);
        if (id < 0) {
            throw new IllegalArgumentException("No action ID defined for:" + actionName);
        }
        this.runActionIfExists(target, id, parms);
    }

    @Override
    public byte[] getCellArrayBytes(long id) {
        this.threadCheck();
        return this.getDelegate().getCellArrayBytes(id);
    }

    @Override
    public CellArray getCellArray(CellArrayId id) {
        return (CellArray)this.cellArrayCache.getUnchecked((Object)id);
    }

    @Override
    public void saveBlueprintData(BlueprintData bpData, byte[] cellArray) {
        this.getDelegate().saveBlueprintData(bpData, cellArray);
    }

    @Override
    public void saveBlueprintData(BlueprintData bpData) {
        byte[] bytes = CellArrayProtocol.toBytes((CellArray)bpData.array);
        this.saveBlueprintData(bpData, bytes);
    }

    @Override
    public void saveAssemblyBlueprintData(AssemblyBlueprintData bpData, byte[] bytes) {
        this.getDelegate().saveAssemblyBlueprintData(bpData, bytes);
    }

    @Override
    public void saveAssemblyBlueprintData(AssemblyBlueprintData bpData) {
        byte[] bytes = SubassemblyProtocol.toBytes(bpData.subassembly);
        this.saveAssemblyBlueprintData(bpData, bytes);
    }

    @Override
    public void saveClothingData(ClothingData cData, byte[] cellArray, byte[] cellArray2) {
        this.getDelegate().saveClothingData(cData, cellArray, cellArray2);
    }

    @Override
    public void saveClothingData(ClothingData cData) {
        log.info("saveClothingData() array1:" + System.identityHashCode(cData.array) + " array2:" + System.identityHashCode(cData.array2));
        byte[] bytes = CellArrayProtocol.toBytes((CellArray)cData.array);
        byte[] bytes2 = cData.array2 == null ? new byte[]{} : CellArrayProtocol.toBytes((CellArray)cData.array2);
        this.saveClothingData(cData, bytes, bytes2);
    }

    private GameSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (GameSession)this.rmiService.getRemoteObject(GameSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No game session found");
            }
        }
        return this.delegate;
    }

    public void addGameSessionListener(GameSessionListener l) {
        this.listeners.add(l);
    }

    public void removeGameSessionListener(GameSessionListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionClientService requires RMI service");
        }
        log.info("Sharing session callback.");
        this.rmiService.share((Object)this.sessionCallback, GameSessionListener.class);
        this.strings = ((EntityDataClientService)this.getService(EntityDataClientService.class)).getEntityData().getStrings();
    }

    public void start() {
        log.debug("start()");
        super.start();
    }

    private class GameSessionCallback
    implements GameSessionListener {
        private GameSessionCallback() {
        }

        @Override
        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
            GameSessionClientService.this.avatar = avatar;
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.setAvatar(avatar);
            }
        }

        @Override
        public void newConsoleMessage(String msg) {
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.newConsoleMessage(msg);
            }
        }

        @Override
        public void showPrompt(EntityId target, PromptType type, String prompt) {
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.showPrompt(target, type, prompt);
            }
        }

        @Override
        public final void showOptions(EntityId target, List<Option<EntityId>> options) {
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.showOptions(target, options);
            }
        }

        @Override
        public final void showOptions(EntityId target, List<Option<EntityId>> options, Option<EntityId> closeOption) {
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.showOptions(target, options, closeOption);
            }
        }

        @Override
        public void openContainer(EntityId container) {
            log.info("openContainer(" + container + ")");
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.openContainer(container);
            }
        }

        @Override
        public void closeContainer(EntityId container) {
            log.info("closeContainer(" + container + ")");
            for (GameSessionListener l : GameSessionClientService.this.listeners) {
                l.closeContainer(container);
            }
        }
    }
}

