/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import java.util.function.Consumer;
import java.util.function.Predicate;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.AbstractDecoratingBehavior;
import mythruna.sim.ai.AgentDriver;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.SteeringPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Behaviors {
    static Logger log = LoggerFactory.getLogger(Behaviors.class);

    public static Behavior constant(String defaultAction, SteeringPrimitive steering) {
        return new Constant(defaultAction, steering);
    }

    public static Behavior limited(Behavior delegate, double timeout) {
        return new Limited(delegate, timeout);
    }

    public static DoWhile doWhile(Behavior delegate, Predicate<Brain> condition) {
        return new DoWhile(delegate, condition);
    }

    public static Behavior fly(Behavior delegate) {
        return new Fly(delegate);
    }

    private static class Constant
    extends AbstractBehavior {
        private String defaultAction;
        private SteeringPrimitive steering;

        public Constant(String defaultAction, SteeringPrimitive steering) {
            this.defaultAction = defaultAction;
            this.steering = steering;
        }

        @Override
        protected void onStart(Brain brain) {
            this.getBrain().getAgent().setDefaultAction(this.defaultAction);
            this.getBrain().getAgent().setSteering(this.steering);
        }

        @Override
        public boolean update(long frameTime, double step) {
            return true;
        }
    }

    private static class Limited
    extends AbstractDecoratingBehavior {
        private double timeout;
        private double time;

        public Limited(Behavior delegate, double timeout) {
            super(delegate);
            this.timeout = timeout;
        }

        @Override
        protected boolean isActive() {
            return this.time < this.timeout && super.isActive();
        }

        @Override
        protected void onStart(Brain brain) {
            this.time = 0.0;
            super.onStart(brain);
        }

        @Override
        public boolean update(long frameTime, double step) {
            boolean result = super.update(frameTime, step);
            this.time += step;
            return this.time < this.timeout && result;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[timeout:" + this.timeout + ", delegate:" + this.getDelegate() + "]";
        }
    }

    public static class DoWhile
    extends AbstractDecoratingBehavior {
        private Predicate<Brain> condition;
        private Consumer<Brain> onDone;
        private Consumer<Brain> onInterrupted;

        public DoWhile(Behavior delegate, Predicate<Brain> condition) {
            super(delegate);
            this.condition = condition;
        }

        public boolean isConditionMet() {
            return this.condition.test(this.getBrain());
        }

        @Override
        protected boolean isActive() {
            return this.isConditionMet() && super.isActive();
        }

        @Override
        protected void onStop() {
            if (!this.isConditionMet()) {
                if (this.onDone != null) {
                    this.onDone.accept(this.getBrain());
                }
            } else if (this.onInterrupted != null) {
                this.onInterrupted.accept(this.getBrain());
            }
        }

        public DoWhile onDone(Consumer<Brain> onDone) {
            this.onDone = onDone;
            return this;
        }

        public DoWhile onInterrupted(Consumer<Brain> onInterrupted) {
            this.onInterrupted = onInterrupted;
            return this;
        }
    }

    private static class Fly
    extends AbstractDecoratingBehavior {
        private AgentDriver driver;

        public Fly(Behavior delegate) {
            super(delegate);
        }

        @Override
        protected void onStart(Brain brain) {
            this.driver = brain.getAgent();
            this.driver.setFlying(true);
            super.onStart(brain);
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.driver.setFlying(false);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[driver:" + this.driver + ", delegate:" + this.getDelegate() + "]";
        }
    }
}

