/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text.md;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.text.md.MdElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageElement
implements MdElement {
    static Logger log = LoggerFactory.getLogger(ImageElement.class);
    private static final Pattern IMAGE = Pattern.compile("!\\[(.*?)\\]\\((.*?)(?:\\s\"(.*?)\")\\)?(?:\\{(.*?)\\})?");
    private static final Pattern STYLE = Pattern.compile("\\s*(\\w+?)\\s*=\\s*(\\S+)");
    private String altText;
    private String imagePath;
    private String toolTip;
    private String style;
    private String after;
    private Map<String, String> styleMap;

    protected ImageElement(String altText, String imagePath, String toolTip, String style, String after) {
        this.altText = altText.trim();
        this.imagePath = imagePath.trim();
        this.toolTip = toolTip.trim();
        this.after = after.trim();
        if (style != null) {
            this.style = style.trim();
            if (style.length() > 0) {
                this.styleMap = ImageElement.parseStyle(style);
            }
        }
    }

    public static ImageElement matches(String line) {
        Matcher m = IMAGE.matcher(line);
        if (!m.lookingAt()) {
            return null;
        }
        String s = "";
        if (m.end() < line.length()) {
            s = line.substring(m.end()).trim();
        }
        return new ImageElement(m.group(1), m.group(2), m.group(3), m.group(4), s);
    }

    public static Map<String, String> parseStyle(String style) {
        if (log.isTraceEnabled()) {
            log.trace("parseStyle(" + style + ") with:" + STYLE.pattern());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher m = STYLE.matcher(style);
        while (m.find()) {
            if (log.isTraceEnabled()) {
                log.trace("found[" + m.group(1) + "][" + m.group(2) + "]");
            }
            result.put(m.group(1), m.group(2));
        }
        return result;
    }

    @Override
    public void append(String s) {
        throw new UnsupportedOperationException("append() not supported for image elements");
    }

    @Override
    public String getText() {
        return this.after;
    }

    public String getAltText() {
        return this.altText;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public Map<String, String> getStyleMap() {
        return this.styleMap;
    }

    public String getStyle(String key, String defaultValue) {
        String val = this.styleMap == null ? null : this.styleMap.get(key);
        return val == null ? defaultValue : val;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("altText", (Object)this.altText).add("imagePath", (Object)this.imagePath).add("toolTip", (Object)this.toolTip).add("styleMap", this.styleMap).add("text", (Object)this.after).toString();
    }
}

