/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.EntityCriteria;
import com.simsilica.es.Query;
import com.simsilica.es.base.EntityDataStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdEntityDataStats
implements EntityDataStats {
    static Logger log = LoggerFactory.getLogger(ThresholdEntityDataStats.class);
    private final long thresholdNanos;
    private final boolean includeStackTrace;

    public ThresholdEntityDataStats() {
        this(13000000L, true);
    }

    public ThresholdEntityDataStats(long thresholdNanos, boolean includeStackTrace) {
        this.thresholdNanos = thresholdNanos;
        this.includeStackTrace = includeStackTrace;
    }

    @Override
    public void findEntities(long nanos, EntityCriteria criteria, Query query, int results) {
        if (nanos > this.thresholdNanos) {
            String msg = String.format("findEntities() threshold exceeded: %.03f ms, %d results, %s, %s", (double)nanos / 1000000.0, results, criteria, query);
            if (this.includeStackTrace) {
                log.warn(msg, new Throwable("stack-trace"));
            } else {
                log.warn(msg);
            }
        }
    }

    @Override
    public void findEntity(long nanos, EntityCriteria criteria, Query query, boolean found) {
        if (nanos > this.thresholdNanos) {
            String msg = String.format("findEntity() threshold exceeded: %.03f ms, found: %s, %s, %s", (double)nanos / 1000000.0, found, criteria, query);
            if (this.includeStackTrace) {
                log.warn(msg, new Throwable("stack-trace"));
            } else {
                log.warn(msg);
            }
        }
    }
}

