/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.base.MoreObjects;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileResolutionId {
    static Logger log = LoggerFactory.getLogger(TileResolutionId.class);
    private TileId tileId;
    private Resolution resolution;

    public TileResolutionId(TileId tileId, Resolution resolution) {
        this.tileId = tileId;
        this.resolution = resolution == null ? Resolution.High : resolution;
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public SedectileId getParentId() {
        return this.tileId.getSedectileId();
    }

    public TileResolutionId getLowerResolution() {
        Resolution lower = this.resolution.getLowerResolution();
        return lower == null ? null : new TileResolutionId(this.tileId, lower);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tileId, this.resolution});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TileResolutionId other = (TileResolutionId)o;
        if (other.resolution != this.resolution) {
            return false;
        }
        return this.tileId.getId() == other.tileId.getId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("tileId", (Object)this.tileId).add("resolution", (Object)this.resolution).toString();
    }
}

