/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.GeomUtils;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PrimitiveType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomPart
implements Cloneable,
Serializable {
    static Logger log = LoggerFactory.getLogger(GeomPart.class);
    static final long serialVersionUID = 42L;
    private MaterialType materialType;
    private PrimitiveType primitiveType;
    private int dir = -1;
    private boolean floatTexCoords;
    private float[] coords;
    private float[] norms;
    private float[] texes;
    private float[] tangents;
    private short[] indexes;
    private float[] colors;
    private float[] sizes;

    public GeomPart(MaterialType materialType, int dir, boolean floatTexCoords) {
        this(materialType, PrimitiveType.Triangles, dir, floatTexCoords);
    }

    public GeomPart(MaterialType materialType) {
        this(materialType, PrimitiveType.Triangles, -1, false);
    }

    public GeomPart(MaterialType materialType, PrimitiveType primitiveType) {
        this(materialType, primitiveType, -1, false);
    }

    public GeomPart(MaterialType materialType, PrimitiveType primitiveType, int dir, boolean floatTexCoords) {
        this.materialType = materialType;
        this.primitiveType = primitiveType;
        this.dir = dir;
        this.floatTexCoords = floatTexCoords;
    }

    public GeomPart invert() {
        return this.invert(this.materialType);
    }

    public GeomPart invert(MaterialType materialType) {
        if (this.primitiveType != PrimitiveType.Triangles) {
            throw new UnsupportedOperationException("Can only invert triangle-based geometry.");
        }
        if (this.indexes == null || this.indexes.length == 0) {
            throw new UnsupportedOperationException("Can only invert index-based geometry.");
        }
        GeomPart clone = this.clone();
        clone.materialType = materialType;
        short[] newIndexes = clone.indexes = (short[])clone.indexes.clone();
        for (int i = 0; i < newIndexes.length; i += 3) {
            short swap = newIndexes[i + 1];
            newIndexes[i + 1] = newIndexes[i + 2];
            newIndexes[i + 2] = swap;
        }
        if (clone.norms != null) {
            float[] newNorms = clone.norms = (float[])clone.norms.clone();
            int i = 0;
            while (i < newNorms.length) {
                int n = i++;
                newNorms[n] = newNorms[n] * -1.0f;
            }
        }
        if (clone.dir != -1) {
            clone.dir += 6;
        }
        return clone;
    }

    public static GeomPart createFace(MaterialType materialType, Direction dir) {
        GeomPart part = new GeomPart(materialType, dir == null ? -1 : dir.ordinal(), false);
        part.texes = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        part.indexes = new short[]{0, 1, 2, 0, 2, 3};
        switch (dir) {
            case North: {
                part.coords = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
                break;
            }
            case South: {
                part.coords = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
                break;
            }
            case East: {
                part.coords = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                break;
            }
            case West: {
                part.coords = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f};
                break;
            }
            case Up: {
                part.coords = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
                break;
            }
            case Down: {
                part.coords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
            }
        }
        if (!materialType.needsIndexedNormals() && dir != null) {
            if (materialType.needsNormals()) {
                part.generateNormals(dir);
            }
            if (materialType.needsTangents()) {
                part.generateTangents(dir);
            }
        }
        return part;
    }

    public static GeomPart createQuad(Vec3d min, Vec3d max, MaterialType materialType, Direction dir) {
        return GeomPart.createQuad(min, max, materialType, dir, true);
    }

    public static GeomPart createQuad(Vec3d min, Vec3d max, MaterialType materialType, Direction dir, boolean stretch) {
        GeomPart part = new GeomPart(materialType, dir.ordinal(), false);
        if (stretch) {
            part.texes = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        }
        part.indexes = new short[]{0, 1, 2, 0, 2, 3};
        switch (dir) {
            case North: {
                part.coords = new float[]{(float)max.x, (float)min.y, (float)min.z, (float)min.x, (float)min.y, (float)min.z, (float)min.x, (float)max.y, (float)min.z, (float)max.x, (float)max.y, (float)min.z};
                if (stretch) break;
                part.texes = new float[]{1.0f - (float)max.x, (float)min.y, 1.0f - (float)min.x, (float)min.y, 1.0f - (float)min.x, (float)max.y, 1.0f - (float)max.x, (float)max.y};
                break;
            }
            case South: {
                part.coords = new float[]{(float)min.x, (float)min.y, (float)max.z, (float)max.x, (float)min.y, (float)max.z, (float)max.x, (float)max.y, (float)max.z, (float)min.x, (float)max.y, (float)max.z};
                if (stretch) break;
                part.texes = new float[]{(float)min.x, (float)min.y, (float)max.x, (float)min.y, (float)max.x, (float)max.y, (float)min.x, (float)max.y};
                break;
            }
            case East: {
                part.coords = new float[]{(float)max.x, (float)min.y, (float)max.z, (float)max.x, (float)min.y, (float)min.z, (float)max.x, (float)max.y, (float)min.z, (float)max.x, (float)max.y, (float)max.z};
                if (stretch) break;
                part.texes = new float[]{1.0f - (float)max.z, (float)min.y, 1.0f - (float)min.z, (float)min.y, 1.0f - (float)min.z, (float)max.y, 1.0f - (float)max.z, (float)max.y};
                break;
            }
            case West: {
                part.coords = new float[]{(float)min.x, (float)min.y, (float)min.z, (float)min.x, (float)min.y, (float)max.z, (float)min.x, (float)max.y, (float)max.z, (float)min.x, (float)max.y, (float)min.z};
                if (stretch) break;
                part.texes = new float[]{(float)min.z, (float)min.y, (float)max.z, (float)min.y, (float)max.z, (float)max.y, (float)min.z, (float)max.y};
                break;
            }
            case Up: {
                part.coords = new float[]{(float)min.x, (float)max.y, (float)max.z, (float)max.x, (float)max.y, (float)max.z, (float)max.x, (float)max.y, (float)min.z, (float)min.x, (float)max.y, (float)min.z};
                if (stretch) break;
                part.texes = new float[]{(float)min.x, 1.0f - (float)max.z, (float)max.x, 1.0f - (float)max.z, (float)max.x, 1.0f - (float)min.z, (float)min.x, 1.0f - (float)min.z};
                break;
            }
            case Down: {
                part.coords = new float[]{(float)min.x, (float)min.y, (float)min.z, (float)max.x, (float)min.y, (float)min.z, (float)max.x, (float)min.y, (float)max.z, (float)min.x, (float)min.y, (float)max.z};
                if (stretch) break;
                part.texes = new float[]{(float)min.x, (float)min.z, (float)max.x, (float)min.z, (float)max.x, (float)max.z, (float)min.x, (float)max.z};
            }
        }
        if (!materialType.needsIndexedNormals() && dir != null) {
            if (materialType.needsNormals()) {
                part.generateNormals(dir);
            }
            if (materialType.needsTangents()) {
                part.generateTangents(dir);
            }
        }
        return part;
    }

    public static Vec3d getNormal(Direction dir) {
        return dir.getVec3i().toVec3d();
    }

    public static Vec3d getTangent(Direction dir) {
        switch (dir) {
            case North: {
                return new Vec3d(-1.0, 0.0, 0.0);
            }
            case South: {
                return new Vec3d(1.0, 0.0, 0.0);
            }
            case East: {
                return new Vec3d(0.0, 0.0, -1.0);
            }
            case West: {
                return new Vec3d(0.0, 0.0, 1.0);
            }
            case Up: {
                return new Vec3d(1.0, 0.0, 0.0);
            }
            case Down: {
                return new Vec3d(1.0, 0.0, 0.0);
            }
        }
        throw new IllegalArgumentException("Unnknown dir:" + (Object)((Object)dir));
    }

    protected void generateNormals(Direction dir) {
        if (log.isTraceEnabled()) {
            log.trace("generateNormals(" + (Object)((Object)dir) + ")");
        }
        Vec3i v = dir.getVec3i();
        this.norms = new float[this.getVertexCount() * 3];
        int index = 0;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.norms[index++] = v.x;
            this.norms[index++] = v.y;
            this.norms[index++] = v.z;
        }
    }

    protected void generateTangents(Direction dir) {
        if (log.isTraceEnabled()) {
            log.trace("generateTangents(" + (Object)((Object)dir) + ")");
        }
        Vec3d v = GeomPart.getTangent(dir);
        this.tangents = new float[this.getVertexCount() * 3];
        int index = 0;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.tangents[index++] = (float)v.x;
            this.tangents[index++] = (float)v.y;
            this.tangents[index++] = (float)v.z;
        }
    }

    public void setupAlternates() {
        if (this.dir < 0) {
            return;
        }
        if (this.materialType.requires(GeomReq.IndexedNormals)) {
            log.trace("Clearing normal and tangent buffers");
            this.norms = null;
            this.tangents = null;
            return;
        }
        int dirUnflipped = this.dir % 6;
        Direction d = Direction.values()[dirUnflipped];
        if (this.materialType.requires(GeomReq.Normals) && this.norms == null) {
            if (this.dir >= 6) {
                this.generateNormals(d.reverse());
            } else {
                this.generateNormals(d);
            }
        }
        if (this.materialType.requires(GeomReq.Tangents) && this.tangents == null) {
            this.generateTangents(d);
        }
    }

    public GeomPart clone() {
        try {
            GeomPart result = (GeomPart)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning geom part", e);
        }
    }

    public EnumSet<GeomReq> calculateGeomCaps() {
        EnumSet<GeomReq> result = EnumSet.noneOf(GeomReq.class);
        if (this.hasIndexedNormals()) {
            result.add(GeomReq.IndexedNormals);
        }
        if (this.norms != null) {
            result.add(GeomReq.Normals);
        }
        if (this.tangents != null) {
            result.add(GeomReq.Tangents);
        }
        if (this.colors != null) {
            result.add(GeomReq.Colors);
        }
        if (this.sizes != null) {
            result.add(GeomReq.Sizes);
        }
        result = GeomReq.expandImplied(result);
        return result;
    }

    public void setMaterialType(MaterialType materialType) {
        this.materialType = materialType;
        this.setupAlternates();
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public int getDirectionIndex() {
        return this.dir;
    }

    public boolean hasIndexedNormals() {
        return this.dir != -1;
    }

    public boolean requiresFloatTexCoords() {
        return this.floatTexCoords;
    }

    public void setCoords(float ... f) {
        this.coords = f;
    }

    public float[] getCoords() {
        return this.coords;
    }

    public int getVertexCount() {
        return this.coords.length / 3;
    }

    public void setNormals(float ... f) {
        if (this.hasIndexedNormals()) {
            log.error("Setting normals on a part with indexed normals.");
        }
        this.norms = f;
    }

    public float[] getNormals() {
        return this.norms;
    }

    public void setTangents(float ... f) {
        if (this.hasIndexedNormals()) {
            log.error("Setting tangents on a part with indexed normals.");
        }
        this.tangents = f;
    }

    public float[] getTangents() {
        return this.tangents;
    }

    public void setTexCoords(float ... f) {
        this.texes = f;
    }

    public float[] getTexCoords() {
        return this.texes;
    }

    public void setIndexes(short ... s) {
        this.indexes = s;
    }

    public void setIndexes(int ... ints) {
        this.indexes = new short[ints.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = (short)ints[i];
        }
    }

    public short[] getIndexes() {
        return this.indexes;
    }

    public void setColors(float ... f) {
        this.colors = f;
    }

    public float[] getColors() {
        return this.colors;
    }

    public void setSizes(float ... f) {
        this.sizes = f;
    }

    public float[] getSizes() {
        return this.sizes;
    }

    public int getTriangleCount() {
        if (this.indexes != null) {
            return this.primitiveType.getCount(this.indexes.length);
        }
        return this.primitiveType.getCount(this.coords.length / 3);
    }

    public GeomPart rotate(int dirDelta) {
        if (dirDelta < 0 || dirDelta > 3) {
            throw new IllegalArgumentException("dirDelta is out of bounds:" + dirDelta);
        }
        GeomPart result = new GeomPart(this.materialType, this.primitiveType);
        int d = this.dir;
        if (d >= 0) {
            result.dir = GeomUtils.rotateIndex(d %= 6, dirDelta);
            if (this.dir >= 6) {
                result.dir += 6;
            }
        }
        if (d < 0) {
            result.norms = GeomUtils.rotateDir(this.norms, dirDelta);
            result.tangents = GeomUtils.rotateDir(this.tangents, dirDelta);
        }
        result.coords = GeomUtils.rotatePos(this.coords, dirDelta);
        if (d >= 4) {
            int vertCount = this.coords.length / 3;
            result.texes = GeomUtils.rotateUvs(this.texes, vertCount, Direction.values()[d], -dirDelta);
        } else {
            result.texes = this.texes == null ? null : (float[])this.texes.clone();
        }
        result.floatTexCoords = this.floatTexCoords;
        result.indexes = this.indexes == null ? null : (short[])this.indexes.clone();
        result.colors = this.colors == null ? null : (float[])this.colors.clone();
        result.sizes = this.sizes == null ? null : (float[])this.sizes.clone();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GeomPart other = (GeomPart)o;
        if (other.dir != this.dir) {
            return false;
        }
        if (other.floatTexCoords != this.floatTexCoords) {
            return false;
        }
        if (!Objects.equals(other.materialType, this.materialType)) {
            return false;
        }
        if (!Objects.equals((Object)other.primitiveType, (Object)this.primitiveType)) {
            return false;
        }
        if (!Arrays.equals(other.coords, this.coords)) {
            return false;
        }
        if (!Arrays.equals(other.norms, this.norms)) {
            return false;
        }
        if (!Arrays.equals(other.texes, this.texes)) {
            return false;
        }
        if (!Arrays.equals(other.tangents, this.tangents)) {
            return false;
        }
        if (!Arrays.equals(other.indexes, this.indexes)) {
            return false;
        }
        if (!Arrays.equals(other.colors, this.colors)) {
            return false;
        }
        return Arrays.equals(other.sizes, this.sizes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dir, this.floatTexCoords, this.materialType, this.primitiveType, Arrays.hashCode(this.coords), Arrays.hashCode(this.norms), Arrays.hashCode(this.texes), Arrays.hashCode(this.tangents), Arrays.hashCode(this.indexes), Arrays.hashCode(this.colors), Arrays.hashCode(this.sizes)});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("materialType", (Object)this.materialType).add("primitiveType", (Object)this.primitiveType).add("directionIndex", this.dir).add("vertexCount", this.getVertexCount()).add("triangleCount", this.getTriangleCount()).toString();
    }
}

