/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import mythruna.client.ui.FontType;
import mythruna.text.CsvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontTypeIndex {
    static Logger log = LoggerFactory.getLogger(FontTypeIndex.class);
    public static final String FONT_INDEX_CSV = "interface/fonts.csv";
    private Map<String, FontType> index = new TreeMap<String, FontType>();

    public Set<String> getFontNames() {
        return this.index.keySet();
    }

    public Collection<FontType> getFontTypes() {
        return this.index.values();
    }

    public FontType getFont(String name) {
        return this.index.get(name);
    }

    public static FontTypeIndex create(Function<String, String> textFunc) {
        String text = textFunc.apply(FONT_INDEX_CSV);
        return FontTypeIndex.create(text);
    }

    public static FontTypeIndex create(String text) {
        List records = CsvUtils.csvToRecords((String)text, (int)0, (char)'\t');
        FontTypeIndex result = new FontTypeIndex();
        for (Map record : records) {
            FontType type = new FontType((String)record.get("name"), (String)record.get("font"));
            result.index.put(type.getName(), type);
        }
        return result;
    }
}

