/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.navigation;

import java.text.DecimalFormat;
import jme3tools.navigation.InvalidPositionException;
import jme3tools.navigation.NumUtil;
import jme3tools.navigation.StringUtil;

public class Coordinate {
    private int deg;
    private double minsDecMins;
    private double decCoordinate;
    private int coOrdinate;
    public static final int MINPRECISION = 4;
    public static final int DEGPRECISION = 7;
    public static final int LAT = 0;
    public static final int LNG = 1;
    public static final int E = 0;
    public static final int S = 1;
    public static final int W = 2;
    public static final int N = 3;

    public Coordinate(int deg, float minsDecMins, int coOrdinate, int quad) throws InvalidPositionException {
        this.buildCoOrdinate(deg, minsDecMins, coOrdinate, quad);
        if (!this.verify()) {
            throw new InvalidPositionException();
        }
    }

    public Coordinate(double decCoordinate, int coOrdinate) throws InvalidPositionException {
        DecimalFormat form = new DecimalFormat("#.#######");
        this.decCoordinate = decCoordinate;
        this.coOrdinate = coOrdinate;
        if (this.verify()) {
            this.deg = new Float(decCoordinate).intValue();
            this.minsDecMins = this.deg < 0 ? Double.parseDouble(form.format((Math.abs(decCoordinate) - (double)Math.abs(this.deg)) * 60.0)) : Double.parseDouble(form.format((decCoordinate - (double)this.deg) * 60.0));
        } else {
            throw new InvalidPositionException();
        }
    }

    public Coordinate(String coOrdinate) throws InvalidPositionException {
        String[] items = coOrdinate.split("\u00b0");
        int deg = Integer.valueOf(items[0]);
        items = items[1].split("'");
        float minsDecMins = Float.valueOf(items[0]).floatValue();
        char quad = items[1].charAt(0);
        switch (quad) {
            case 'N': {
                this.buildCoOrdinate(deg, minsDecMins, 0, 3);
                break;
            }
            case 'S': {
                this.buildCoOrdinate(deg, minsDecMins, 0, 1);
                break;
            }
            case 'E': {
                this.buildCoOrdinate(deg, minsDecMins, 1, 0);
                break;
            }
            case 'W': {
                this.buildCoOrdinate(deg, minsDecMins, 1, 2);
            }
        }
        if (!this.verify()) {
            throw new InvalidPositionException();
        }
    }

    public String toStringDegMin() {
        String str = "";
        String quad = "";
        StringUtil su = new StringUtil();
        switch (this.coOrdinate) {
            case 0: {
                quad = this.decCoordinate >= 0.0 ? "N" : "S";
                str = su.padNumZero(Math.abs(this.deg), 2);
                str = str + "\u00b0" + su.padNumZero(Math.abs(this.minsDecMins), 2, 4) + "'" + quad;
                break;
            }
            case 1: {
                quad = this.decCoordinate >= 0.0 ? "E" : "W";
                str = su.padNumZero(Math.abs(this.deg), 3);
                str = str + "\u00b0" + su.padNumZero(Math.abs(this.minsDecMins), 2, 4) + "'" + quad;
            }
        }
        return str;
    }

    public String toStringDec() {
        StringUtil u = new StringUtil();
        switch (this.coOrdinate) {
            case 0: {
                return u.padNumZero(this.decCoordinate, 2, 7);
            }
            case 1: {
                return u.padNumZero(this.decCoordinate, 3, 7);
            }
        }
        return "error";
    }

    public double decVal() {
        return this.decCoordinate;
    }

    private boolean verify() {
        switch (this.coOrdinate) {
            case 0: {
                if (!(Math.abs(this.decCoordinate) > 90.0)) break;
                return false;
            }
            case 1: {
                if (!(Math.abs(this.decCoordinate) > 180.0)) break;
                return false;
            }
        }
        return true;
    }

    private void buildCoOrdinate(int deg, float minsDecMins, int coOrdinate, int quad) {
        NumUtil nu = new NumUtil();
        block0 : switch (coOrdinate) {
            case 0: {
                switch (quad) {
                    case 3: {
                        this.deg = deg;
                        this.minsDecMins = minsDecMins;
                        this.coOrdinate = coOrdinate;
                        this.decCoordinate = nu.Round((float)this.deg + (float)this.minsDecMins / 60.0f, 4);
                        break;
                    }
                    case 1: {
                        this.deg = -deg;
                        this.minsDecMins = minsDecMins;
                        this.coOrdinate = coOrdinate;
                        this.decCoordinate = nu.Round((float)this.deg - (float)this.minsDecMins / 60.0f, 4);
                    }
                }
            }
            case 1: {
                switch (quad) {
                    case 0: {
                        this.deg = deg;
                        this.minsDecMins = minsDecMins;
                        this.coOrdinate = coOrdinate;
                        this.decCoordinate = nu.Round((float)this.deg + (float)this.minsDecMins / 60.0f, 4);
                        break block0;
                    }
                    case 2: {
                        this.deg = -deg;
                        this.minsDecMins = minsDecMins;
                        this.coOrdinate = coOrdinate;
                        this.decCoordinate = nu.Round((float)this.deg - (float)this.minsDecMins / 60.0f, 4);
                    }
                }
            }
        }
    }
}

