/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetProcessor;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.SimpleAssetCache;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssetKey<T>
implements Savable,
Cloneable {
    protected String name;
    protected transient String folder;
    protected transient String extension;

    public AssetKey(String name) {
        this.name = AssetKey.reducePath(name);
        this.extension = AssetKey.getExtension(this.name);
    }

    public AssetKey() {
    }

    public AssetKey<T> clone() {
        try {
            return (AssetKey)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    protected static String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (name.toLowerCase().endsWith(".xml") && (idx = name.substring(0, idx).lastIndexOf(46)) == -1) {
            idx = name.lastIndexOf(46);
        }
        if (idx <= 0 || idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1).toLowerCase();
    }

    protected static String getFolder(String name) {
        int idx = name.lastIndexOf(47);
        if (idx <= 0 || idx == name.length() - 1) {
            return "";
        }
        return name.substring(0, idx + 1);
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFolder() {
        if (this.folder == null) {
            this.folder = AssetKey.getFolder(this.name);
        }
        return this.folder;
    }

    public Class<? extends AssetCache> getCacheType() {
        return SimpleAssetCache.class;
    }

    public Class<? extends AssetProcessor> getProcessorType() {
        return null;
    }

    public static String reducePath(String path) {
        if (path == null || path.indexOf("./") == -1) {
            return path;
        }
        String[] parts = path.split("/");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String string = parts[i];
            if (string.length() == 0 || string.equals(".")) continue;
            if (string.equals("..")) {
                if (list.size() > 0 && !((String)list.getLast()).equals("..")) {
                    list.removeLast();
                    continue;
                }
                list.add("..");
                Logger.getLogger(AssetKey.class.getName()).log(Level.SEVERE, "Asset path \"{0}\" is outside assetmanager root", path);
                continue;
            }
            list.add(string);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (i != 0) {
                builder.append("/");
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AssetKey)) {
            return false;
        }
        return this.name.equals(((AssetKey)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = AssetKey.reducePath(ic.readString("name", null));
        this.extension = AssetKey.getExtension(this.name);
    }
}

