/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.encounter;

import com.simsilica.sim.SimTime;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mythruna.sim.encounter.Encounter;
import mythruna.sim.encounter.EncounterGenerator;
import mythruna.sim.encounter.Zone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncounterGenerator
implements EncounterGenerator {
    static Logger log = LoggerFactory.getLogger(DefaultEncounterGenerator.class);
    private static Supplier<Double> DEFAULT_PROBABILITY = () -> 1.0;
    private static Function<SimTime, Long> DEFAULT_FUTURE = st -> st.getFutureTime(1.0);
    private static Function<Zone, Boolean> DEFAULT_VALID_CHECK = zone -> false;
    private final Zone zone;
    private final String encounterId;
    private int influenceRadius = 2;
    private Supplier<Double> probability = DEFAULT_PROBABILITY;
    private Function<SimTime, Long> nextTriggerTime = DEFAULT_FUTURE;
    private BiFunction<Zone, SimTime, Encounter> onTrigger;
    private Function<Zone, Boolean> validCheck = DEFAULT_VALID_CHECK;
    private long nextAttempt = -1L;
    private Encounter activeEncounter;

    public DefaultEncounterGenerator(Zone zone, String encounterId) {
        this.zone = zone;
        this.encounterId = encounterId;
    }

    public void setInfluenceRadius(int influenceRadius) {
        this.influenceRadius = influenceRadius;
    }

    public int getInfluenceRadius() {
        return this.influenceRadius;
    }

    public void setProbability(Supplier<Double> probability) {
        this.probability = probability;
    }

    public Supplier<Double> getProbability() {
        return this.probability;
    }

    public void setNextTriggerTime(Function<SimTime, Long> nextTriggerTime) {
        if (log.isTraceEnabled()) {
            log.trace("setNextTriggerTime(" + nextTriggerTime + ")");
        }
        this.nextTriggerTime = nextTriggerTime;
    }

    public Function<SimTime, Long> getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public void setOnTrigger(BiFunction<Zone, SimTime, Encounter> onTrigger) {
        if (log.isTraceEnabled()) {
            log.trace("setOnTrigger(" + onTrigger + ")");
        }
        this.onTrigger = onTrigger;
    }

    public BiFunction<Zone, SimTime, Encounter> getOnTrigger() {
        return this.onTrigger;
    }

    public void setValidCheck(Function<Zone, Boolean> validCheck) {
        this.validCheck = validCheck;
    }

    public Function<Zone, Boolean> getValidCheck() {
        return this.validCheck;
    }

    @Override
    public boolean isValid() {
        return this.validCheck == null ? false : this.validCheck.apply(this.zone);
    }

    @Override
    public void update(SimTime time) {
        if (this.nextAttempt == -1L) {
            this.nextAttempt = this.nextTriggerTime.apply(time);
            return;
        }
        if (this.activeEncounter != null) {
            if (!this.activeEncounter.update(time)) {
                if (log.isTraceEnabled()) {
                    log.trace(this.zone + " deactivating '" + this.encounterId + "'");
                }
                this.zone.deactivate(this.encounterId);
                this.activeEncounter.release();
                this.activeEncounter = null;
                this.nextAttempt = this.nextTriggerTime.apply(time);
            }
            return;
        }
        long t = time.getTime();
        if (t < this.nextAttempt) {
            return;
        }
        double prob = this.probability.get();
        if (prob == 0.0 || Math.random() > prob) {
            this.nextAttempt = this.nextTriggerTime.apply(time);
            return;
        }
        Encounter neighbor = this.zone.getActiveNeighbor(this.encounterId, this.influenceRadius);
        if (neighbor != null) {
            SimTime end = new SimTime();
            end.setCurrentTime(neighbor.getEnd());
            this.nextAttempt = this.nextTriggerTime.apply(end);
            return;
        }
        this.activeEncounter = this.onTrigger.apply(this.zone, time);
        if (this.activeEncounter == null) {
            this.nextAttempt = this.nextTriggerTime.apply(time);
            return;
        }
        this.zone.activate(this.encounterId, this.activeEncounter);
    }

    @Override
    public void release() {
        if (this.activeEncounter != null) {
            this.activeEncounter.release();
        }
    }
}

