/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import mythruna.world.local.BasisData;
import mythruna.world.local.LocalSpaceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalSpaceValue<T, B>
implements VersionedObject<T>,
LocalSpaceValue<T> {
    static Logger log = LoggerFactory.getLogger(AbstractLocalSpaceValue.class);
    private long version;
    private BasisData<B> basis;
    private T value;
    private boolean invalid;

    protected AbstractLocalSpaceValue(BasisData<B> basis, T initialValue) {
        this.basis = basis;
        this.value = initialValue;
    }

    @Override
    public abstract void updatePosition(Vec3d var1, Vec3i var2, Vec3d var3);

    protected abstract T loadValue();

    protected B getData() {
        return this.basis.getData();
    }

    protected boolean isInvalid() {
        return this.invalid || this.basis.isInvalid();
    }

    protected BasisData<B> getBasis() {
        return this.basis;
    }

    public long getVersion() {
        return this.version + this.basis.getVersion();
    }

    public T getObject() {
        this.validate();
        return this.value;
    }

    public VersionedReference<T> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected T getValue() {
        return this.value;
    }

    protected void invalidate() {
        if (this.invalid) {
            return;
        }
        this.invalid = true;
        if (!this.basis.isInvalid()) {
            ++this.version;
        }
    }

    protected void validate() {
        if (!this.invalid) {
            return;
        }
        if (this.basis.isInvalid()) {
            return;
        }
        this.value = this.loadValue();
        this.invalid = false;
    }
}

