/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractElevationGenerator;
import org.progeeks.map.ElevationData;

public class Erosion
extends AbstractElevationGenerator {
    private double filter = 0.5;

    public Erosion() {
        super("Erosion Operator");
    }

    public void setFilter(double filter) {
        if (this.filter == filter) {
            return;
        }
        this.filter = filter;
        this.invalidate();
    }

    public double getFilter() {
        return this.filter;
    }

    @Override
    protected ElevationData generateElevations(ElevationData result) {
        int y;
        int x;
        int x2;
        double d;
        int y2;
        ElevationData source = this.getSourceData();
        int[][] sourceMap = source.getElevations();
        int mapSize = source.getMapSize();
        if (result == null) {
            result = new ElevationData(mapSize);
        }
        int[][] map = result.getElevations();
        for (y2 = 0; y2 < mapSize; ++y2) {
            int n = sourceMap[y2][0];
            map[y2][0] = n;
            d = n;
            for (x2 = 1; x2 < mapSize; ++x2) {
                d = this.filter * d + (1.0 - this.filter) * (double)sourceMap[y2][x2];
                map[y2][x2] = (int)Math.round(d);
            }
        }
        for (y2 = 0; y2 < mapSize; ++y2) {
            d = sourceMap[y2][mapSize - 1];
            for (x2 = mapSize - 1; x2 >= 0; --x2) {
                d = this.filter * d + (1.0 - this.filter) * (double)map[y2][x2];
                map[y2][x2] = (int)Math.round(d);
            }
        }
        for (x = 0; x < mapSize; ++x) {
            d = sourceMap[0][x];
            for (y = 1; y < mapSize; ++y) {
                d = this.filter * d + (1.0 - this.filter) * (double)map[y][x];
                map[y][x] = (int)Math.round(d);
            }
        }
        for (x = 0; x < mapSize; ++x) {
            d = sourceMap[mapSize - 1][x];
            for (y = mapSize - 1; y >= 0; --y) {
                d = this.filter * d + (1.0 - this.filter) * (double)map[y][x];
                map[y][x] = (int)Math.round(d);
            }
        }
        return result;
    }
}

