/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.progeeks.map.ElevationData;

public class ImageGenerator {
    private ElevationData data;
    private BufferedImage colorImage;
    private BufferedImage shadowImage;

    public ImageGenerator(ElevationData data) {
        this.data = data;
    }

    public void setElevationData(ElevationData data) {
        if (this.data == data) {
            return;
        }
        this.data = data;
        this.invalidate();
    }

    public int getMapSize() {
        return this.data.getMapSize();
    }

    public void invalidate() {
        this.colorImage = null;
        this.shadowImage = null;
    }

    protected void regenerateImage() {
        int[][] map = this.data.getElevations();
        int mapSize = this.data.getMapSize();
        if (this.colorImage == null) {
            this.colorImage = new BufferedImage(mapSize, mapSize, 2);
            this.shadowImage = new BufferedImage(mapSize, mapSize, 2);
        }
        int[] buffer = ((DataBufferInt)this.colorImage.getRaster().getDataBuffer()).getData();
        int[] shadow = ((DataBufferInt)this.shadowImage.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int y = 0; y < mapSize; ++y) {
            for (int x = 0; x < mapSize; ++x) {
                int shadowValue;
                int v;
                int b;
                int g;
                int r;
                int color;
                int v2;
                int val = map[y][x];
                if (val < min) {
                    min = val;
                }
                if (val > max) {
                    max = val;
                }
                if (val < -64) {
                    v2 = Math.abs(val) / 62;
                    color = 0xFF000000 | v2;
                } else if (val <= 64) {
                    color = -256;
                } else if (val < 5120) {
                    v2 = val / 20;
                    v2 = 64 + v2 / 2;
                    color = 0xFF000000 | v2 << 8;
                } else if (val < 10240) {
                    v2 = (val - 5120) / 20;
                    r = v2 / 2;
                    g = 196 - v2 / 3;
                    b = 0;
                    color = 0xFF000000 | r << 16 | g << 8 | b;
                } else {
                    v2 = (val - 10240) / 66;
                    r = 128 + v2 / 2;
                    g = Math.min(155, 110 + v2 / 2);
                    b = v2;
                    color = 0xFF000000 | r << 16 | g << 8 | b;
                }
                int center = (val + map[y][x + 1] + map[y + 1][x] + map[y + 1][x + 1]) / 4;
                int slope = center - val;
                if (slope >= 0) {
                    v = slope;
                    if (v >= 256) {
                        v = 255;
                    }
                    if (val < 0) {
                        v >>= 2;
                    }
                    shadowValue = v << 24 | 0xFFFFFF;
                } else {
                    v = -slope;
                    if (v >= 256) {
                        v = 255;
                    }
                    if (val < 0) {
                        v >>= 2;
                    }
                    shadowValue = v << 24;
                }
                shadow[pos] = shadowValue;
                buffer[pos++] = color;
            }
        }
        System.out.println("Lowest point:" + min + "   Highest point:" + max);
    }

    public Image getColorImage() {
        if (this.colorImage == null) {
            this.regenerateImage();
        }
        return this.colorImage;
    }

    public Image getShadowImage() {
        if (this.shadowImage == null) {
            this.regenerateImage();
        }
        return this.shadowImage;
    }
}

