/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.account.base;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.simsilica.account.Account;
import com.simsilica.account.base.AuthResult;
import com.simsilica.account.base.Authenticator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashAuthenticator
implements Authenticator {
    static Logger log = LoggerFactory.getLogger(HashAuthenticator.class);
    public static final HashAuthenticator SHA512 = new HashAuthenticator("sha512", Hashing.sha512());
    private String name;
    private HashFunction hash;

    public HashAuthenticator(String name, HashFunction hash) {
        this.name = name;
        this.hash = hash;
    }

    public String hash(String s) {
        return this.hash.hashString((CharSequence)s, Charsets.UTF_8).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AuthResult authenticate(Account account, String randomSalt, Map<String, Object> credentials) {
        Object cred = credentials.get(this.name);
        if (cred == null) {
            return AuthResult.Ignore;
        }
        String stored = account.getProperty(this.name, String.class);
        String comp = this.hash(randomSalt + stored);
        if (Objects.equals(cred, comp)) {
            return AuthResult.Success;
        }
        return AuthResult.Failure;
    }
}

