/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectAction;
import com.simsilica.action.ObjectType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionContext<A, T> {
    static Logger log = LoggerFactory.getLogger(ActionContext.class);
    private ObjectType<A, T> type;
    private T target;

    public ActionContext(ObjectType<A, T> type, T target) {
        this.type = type;
        this.target = target;
    }

    public ObjectType<A, T> getType() {
        return this.type;
    }

    public T getTarget() {
        return this.target;
    }

    private Class[] toTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] result = new Class[args.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i] == null ? null : args[i].getClass();
        }
        return result;
    }

    protected ObjectAction<A, T> resolveAction(boolean failFast, ObjectType<A, T> actionType, String actionName, Object ... args) {
        ObjectAction<A, T> action = actionType.findAction(actionName, args);
        if (action == null && failFast) {
            throw new IllegalArgumentException("Action not found for:" + actionName + ", actionType:" + actionType + ", args:" + Arrays.asList(args) + ", types:" + Arrays.asList(this.toTypes(args)) + "\nSimilar actions:" + actionType.findNamedActions(actionName) + "\nAll actions:" + actionType.getActionNames());
        }
        return action;
    }

    public boolean hasAction(String actionName, Object ... args) {
        return this.resolveAction(false, this.type, actionName, args) != null;
    }

    public boolean canRun(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(false, this.type, actionName, args);
        if (action == null) {
            return false;
        }
        return action.canRun(env, this, args);
    }

    public boolean canRun(String actionName, Object ... args) {
        ObjectAction action = this.resolveAction(false, this.type, actionName, args);
        if (action == null) {
            return false;
        }
        return action.canRun(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public boolean run(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(true, this.type, actionName, args);
        return action.run(env, this, args);
    }

    public boolean run(String actionName, Object ... args) {
        ObjectAction action = this.resolveAction(true, this.type, actionName, args);
        return action.run(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public boolean runIfExists(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(false, this.type, actionName, args);
        if (action == null) {
            return false;
        }
        return action.run(env, this, args);
    }

    public boolean runIfExists(String actionName, Object ... args) {
        ObjectAction action = this.resolveAction(false, this.type, actionName, args);
        if (action == null) {
            return false;
        }
        return action.run(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public boolean run(ActionEnvironment<A, T> env, ObjectType<A, T> altType, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(true, altType, actionName, args);
        return action.run(env, this, args);
    }

    public boolean run(ObjectType<A, T> altType, String actionName, Object ... args) {
        ObjectAction action = this.resolveAction(true, altType, actionName, args);
        return action.run(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public boolean superRun(ObjectAction<A, T> currentAction, Object ... args) {
        ObjectAction action = this.type.findSuperAction(currentAction, args);
        if (action == null) {
            throw new IllegalArgumentException("Super-action not found for:" + currentAction.getName() + ", actionType:" + this.type + ", args:" + Arrays.asList(args) + ", types:" + Arrays.asList(this.toTypes(args)));
        }
        return action.run(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public boolean superCanRun(ObjectAction<A, T> currentAction, Object ... args) {
        ObjectAction action = this.type.findSuperAction(currentAction, args);
        if (action == null) {
            throw new IllegalArgumentException("Super-action not found for:" + currentAction.getName() + ", actionType:" + this.type + ", args:" + Arrays.asList(args) + ", types:" + Arrays.asList(this.toTypes(args)));
        }
        return action.canRun(ActionEnvironment.getCurrentEnvironment(), this, args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type:" + this.type + ", target:" + this.target + "]";
    }
}

