/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.MassUtils;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.BodyMass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellArrayPart
extends Part {
    static Logger log = LoggerFactory.getLogger(CellArrayPart.class);
    private Type type;
    private CellArray cells;
    private double scale;
    private double blockCollisionPriority;
    private double radius;
    private Vec3d center;

    public CellArrayPart(Type type, CellArray cells, double scale, double boundsRadius, BodyMass mass) {
        this(new Vec3d(), type, cells, scale, boundsRadius, mass);
    }

    public CellArrayPart(Vec3d boundsCenter, Type type, CellArray cells, double scale, double boundsRadius, BodyMass mass) {
        this("cellArray", boundsCenter, type, cells, scale, boundsRadius, mass);
    }

    public CellArrayPart(String name, Vec3d boundsCenter, Type type, CellArray cells, double scale, double boundsRadius, BodyMass mass) {
        super(name);
        this.type = type;
        this.cells = cells;
        this.scale = scale;
        this.center = boundsCenter;
        this.radius = boundsRadius;
        this.setMass(mass);
        if (cells != null) {
            this.blockCollisionPriority = (double)cells.getSizeX() * scale + (double)cells.getSizeY() * scale + (double)cells.getSizeZ() * scale;
        } else {
            double r3 = boundsRadius * scale;
            r3 = r3 * r3 * r3;
            this.blockCollisionPriority = 4.1887902047863905 * r3;
        }
    }

    @Override
    public Part[] traverse() {
        return new Part[]{this};
    }

    @Override
    protected void markForRefresh(int flag) {
        super.markForRefresh(flag);
        if ((flag & 1) != 0) {
            log.info("Who is refreshing mass of a cell part?", new Throwable("who?"));
        }
    }

    @Override
    protected void updateMass() {
        log.info("updatEMass()", new Throwable("why?"));
        this.clearRefreshNeeded(1);
    }

    public Vec3d getCenter() {
        if (this.isRefreshNeeded(1)) {
            this.updateMass();
        }
        return this.center;
    }

    public double getRadius() {
        if (this.isRefreshNeeded(1)) {
            this.updateMass();
        }
        return this.radius;
    }

    public CellArray getCells() {
        return this.cells;
    }

    public void setCells(CellArray cells) {
        this.cells = cells;
    }

    public Vec3d cellToShape(Vec3d cellSpace, Vec3d store) {
        if (store == null) {
            store = cellSpace.mult(this.scale);
        } else {
            store = store.set(cellSpace);
            store.multLocal(this.scale);
        }
        this.getShapeRelativeOrientation().mult(store, store);
        store.addLocal(this.getShapeRelativePosition());
        return store;
    }

    public Vec3d shapeToCell(Vec3d bodySpace, Vec3d store) {
        if (store == null) {
            store = bodySpace.subtract(this.getShapeRelativePosition());
        } else {
            store.set(bodySpace).subtractLocal(this.getShapeRelativePosition());
        }
        this.getShapeRelativeOrientation().inverse().mult(store, store);
        store.multLocal(1.0 / this.scale);
        return store;
    }

    public Vec3d cellToWorld(AbstractBody<?, MBlockShape> body, Vec3d cell, Vec3d store) {
        store = this.cellToShape(cell, store);
        ((MBlockShape)body.shape).shapeToBody(store, store);
        body.localToWorld(store, store);
        return store;
    }

    public Vec3d worldToCell(AbstractBody<?, MBlockShape> body, Vec3d world, Vec3d store) {
        store = body.worldToLocal(world, store);
        ((MBlockShape)body.shape).bodyToShape(store, store);
        this.shapeToCell(store, store);
        return store;
    }

    public Vec3d getWorldPosition(AbstractBody<?, MBlockShape> body, Vec3d store) {
        store = ((MBlockShape)body.shape).shapeToBody(this.getShapeRelativePosition(), store);
        store = body.localToWorld(store, store);
        return store;
    }

    public static CellArrayPart createShape(CellArray cells, double scale, double mass) {
        return CellArrayPart.createShape("cellArray", cells, scale, mass);
    }

    public static CellArrayPart createShape(String name, CellArray cells, double scale, double mass) {
        Vec3i size = cells.getSize();
        Vec3d center = size.toVec3d().multLocal(0.5 * scale);
        double radius = center.length();
        BodyMass bm = MassUtils.calculateBodyMass(cells, scale, mass);
        if (bm == null) {
            log.warn("Cells generated no body mass, name:" + name + " cells.size:" + cells.getSize() + " scale:" + scale + " mass:" + mass);
            bm = BodyMass.createSolidSphere((double)mass, (double)scale, (Vec3d)cells.getSize().toVec3d().mult(0.5));
        }
        return new CellArrayPart(name, center, Type.Blocks, cells, scale, radius, bm);
    }

    public static CellArrayPart createGhost(double radius) {
        return new CellArrayPart(new Vec3d(), Type.Sphere, null, 1.0, radius, BodyMass.createSimple((double)0.0, null, (double)radius));
    }

    public static CellArrayPart createSphere(double radius, double mass) {
        return new CellArrayPart(Type.Sphere, null, 1.0, radius, BodyMass.createSolidSphere((double)mass, (double)radius, null));
    }

    public static CellArrayPart createSphere(String name, double radius, double mass) {
        return new CellArrayPart(name, new Vec3d(), Type.Sphere, null, 1.0, radius, BodyMass.createSolidSphere((double)mass, (double)radius, null));
    }

    public static CellArrayPart createCube(double extents) {
        CellArray cells = new CellArray(1, 1, 1);
        cells.setCell(0, 0, 0, 1);
        MaskUtils.calculateSideMasks((CellArray)cells);
        return CellArrayPart.createShape(cells, extents / 2.0, 0.0);
    }

    public double getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.type;
    }

    public void setBlockCollisionPriority(double blockCollisionPriority) {
        this.blockCollisionPriority = blockCollisionPriority;
    }

    public double getBlockCollisionPriority() {
        return this.blockCollisionPriority;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("name", (Object)this.getName()).add("type", (Object)this.type).add("center", (Object)this.getCenter()).add("radius", this.getRadius()).add("bodyMass", (Object)this.getMass()).toString();
    }

    public static enum Type {
        Sphere,
        Blocks;

    }
}

