/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mworld.db.AbstractObjectDb;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpoolingObjectDb<K, V>
extends AbstractObjectDb<K, V> {
    public static final long DEFAULT_INTERVAL = 1000L;
    static Logger log = LoggerFactory.getLogger(SpoolingObjectDb.class);
    private ConcurrentLinkedQueue<ToStore<K, V>> pending = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<K, ToStore<K, V>> pendingIndex = new ConcurrentHashMap();
    private String name;
    private Spooler spooler;
    private AtomicBoolean running = new AtomicBoolean();
    private long interval;

    public SpoolingObjectDb() {
        this(null, 1000L);
    }

    public SpoolingObjectDb(String name) {
        this(name, 1000L);
    }

    public SpoolingObjectDb(String name, long interval) {
        this.name = name;
        this.interval = interval;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void initialize() {
        if (this.spooler != null) {
            log.warn("initialize(): Double initialization");
            return;
        }
        super.initialize();
        this.spooler = this.name == null ? new Spooler() : new Spooler(this.name);
        this.running.set(true);
        this.spooler.start();
    }

    @Override
    public void terminate() {
        if (this.spooler == null) {
            log.warn("terminate(): Not initialized");
            return;
        }
        this.running.set(false);
        try {
            this.spooler.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for spooler completion:" + this.spooler, e);
        }
        this.spoolAllPending();
        this.spooler = null;
        super.terminate();
    }

    public void kill() {
        this.pendingIndex.clear();
        this.pending.clear();
        this.running.set(false);
        try {
            this.spooler.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for spooler completion:" + this.spooler, e);
        }
        this.pendingIndex.clear();
        this.pending.clear();
        this.spooler = null;
    }

    @Override
    public V get(K key) {
        if (this.spooler == null) {
            throw new IllegalStateException("Not initialized");
        }
        return super.get(key);
    }

    @Override
    public void update(K key, V value) {
        if (this.spooler == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!this.running.get()) {
            throw new IllegalStateException("Spooler is shutting down, update requests rejected");
        }
        ToStore<K, V> store = new ToStore<K, V>(key, value);
        if (this.pendingIndex.putIfAbsent(key, store) == null) {
            this.pending.add(store);
            this.getCache().put(key, value);
        } else if (log.isTraceEnabled()) {
            log.trace("update already pending for:" + key);
        }
    }

    protected abstract void storeObject(K var1, V var2);

    protected void spoolAllPending() {
        ToStore<K, V> store = null;
        while ((store = this.pending.poll()) != null) {
            this.pendingIndex.remove(((ToStore)store).key);
            try {
                this.storeObject(((ToStore)store).key, ((ToStore)store).value);
            }
            catch (Exception e) {
                log.error("Error storing object:" + ((ToStore)store).key, (Throwable)e);
            }
        }
    }

    private class Spooler
    extends Thread {
        public Spooler() {
        }

        public Spooler(String name) {
            super(name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (SpoolingObjectDb.this.running.get()) {
                    try {
                        SpoolingObjectDb.this.spoolAllPending();
                    }
                    catch (Exception e) {
                        log.error("Error spooling", (Throwable)e);
                    }
                    catch (AssertionError e) {
                        log.error("Assertion error spooling", (Throwable)((Object)e));
                    }
                    try {
                        Thread.sleep(SpoolingObjectDb.this.interval);
                    }
                    catch (InterruptedException e) {
                        if (!SpoolingObjectDb.this.running.get()) continue;
                        log.error("Interrupted while sleeping", (Throwable)e);
                        throw new RuntimeException("Interrupted while sleeping", e);
                        return;
                    }
                }
            }
            catch (Throwable t) {
                log.error("Spooling thread is dying", t);
            }
        }
    }

    protected static class ToStore<K, V> {
        private K key;
        private V value;

        public ToStore(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

