/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayer {
    static Logger log = LoggerFactory.getLogger(TreeLayer.class);
    private static int COLUMN_SIZE = 32;
    private TileId tileId;
    private DataVersion version;
    private byte generationLevel;
    private List<Tree> trees;
    private ListMultimap<Short, Tree> binIndex;

    public TreeLayer(TileId tileId, DataVersion version) {
        this(tileId, version, 0, new ArrayList<Tree>());
    }

    public TreeLayer(TileId tileId, DataVersion version, int generationLevel, List<Tree> trees) {
        this.tileId = tileId;
        this.version = version;
        this.generationLevel = (byte)generationLevel;
        this.trees = trees;
        this.binIndex = MultimapBuilder.hashKeys().arrayListValues().build();
        for (Tree tree : trees) {
            this.indexTree(tree);
        }
    }

    private int localToBin(int val) {
        if (val < 0) {
            return 0;
        }
        return Math.min(val / COLUMN_SIZE, 31);
    }

    private short toBinId(int x, int z) {
        return (short)(z << 5 | x);
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void setGenerationLevel(int generationLevel) {
        if (this.generationLevel > generationLevel) {
            throw new IllegalArgumentException("Generation level cannot go backwards.");
        }
        this.generationLevel = (byte)generationLevel;
    }

    public int getGenerationLevel() {
        return this.generationLevel;
    }

    public List<Tree> getTrees() {
        return this.trees;
    }

    public Set<Short> getActiveBinIds() {
        return this.binIndex.keySet();
    }

    public boolean addTree(Tree tree) {
        if (!this.trees.add(tree)) {
            return false;
        }
        this.indexTree(tree);
        return true;
    }

    public boolean removeTree(Tree tree) {
        if (!this.trees.remove(tree)) {
            return false;
        }
        this.unindexTree(tree);
        return true;
    }

    protected void indexTree(Tree tree) {
        int xMin = this.localToBin(tree.x - tree.radius);
        int zMin = this.localToBin(tree.z - tree.radius);
        int xMax = this.localToBin(tree.x + tree.radius);
        int zMax = this.localToBin(tree.z + tree.radius);
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                short binId = this.toBinId(x, z);
                this.binIndex.put((Object)binId, (Object)tree);
            }
        }
    }

    protected void unindexTree(Tree tree) {
        int xMin = this.localToBin(tree.x - tree.radius);
        int zMin = this.localToBin(tree.z - tree.radius);
        int xMax = this.localToBin(tree.x + tree.radius);
        int zMax = this.localToBin(tree.z + tree.radius);
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                short binId = this.toBinId(x, z);
                this.binIndex.remove((Object)binId, (Object)tree);
            }
        }
    }

    public List<Tree> getTrees(ColumnId colId) {
        return this.getTrees(colId.getWorld(null));
    }

    public List<Tree> getTrees(Vec3i world) {
        Vec3i origin = this.getTileId().getWorld(null);
        int x = (world.x - origin.x) / COLUMN_SIZE;
        int z = (world.z - origin.z) / COLUMN_SIZE;
        if (x < 0 || z < 0) {
            throw new IllegalArgumentException("Location:" + world + " not in layer at:" + this.getTileId());
        }
        if (x >= 32 || z >= 32) {
            throw new IllegalArgumentException("Location:" + world + " not in layer at:" + this.getTileId());
        }
        return this.getBinTrees(x, z);
    }

    public List<Tree> getLocalTrees(int xLocal, int zLocal) {
        int x = xLocal / COLUMN_SIZE;
        int z = zLocal / COLUMN_SIZE;
        if (x < 0 || z < 0) {
            throw new IllegalArgumentException("Location:" + xLocal + ", " + zLocal + " not in layer at:" + this.getTileId());
        }
        if (x >= 32 || z >= 32) {
            throw new IllegalArgumentException("Location:" + xLocal + ", " + zLocal + " not in layer at:" + this.getTileId());
        }
        return this.getBinTrees(x, z);
    }

    protected List<Tree> getBinTrees(int xBin, int zBin) {
        short binId = this.toBinId(xBin, zBin);
        List result = this.binIndex.get((Object)binId);
        return result;
    }

    public boolean apply(ColumnData col, Tile tile) {
        ColumnId columnId = col.getColumnId();
        List<Tree> local = this.getTrees(columnId);
        if (local.isEmpty()) {
            return false;
        }
        Random rand = new Random(columnId.getId());
        boolean updated = false;
        TileColumnCells cells = new TileColumnCells(col);
        for (Tree tree : local) {
            if (!tree.type.insertTree(tree, cells, rand)) continue;
            updated = true;
        }
        return updated;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[tileId:" + this.tileId + ", version:" + this.version + ", size:" + this.trees.size() + "]";
    }
}

