/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import mythruna.world.cave.Influencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WallInfluencer
extends AbstractMorphology
implements Influencer,
Serializable {
    static Logger log = LoggerFactory.getLogger(WallInfluencer.class);
    private static final long serialVersionUID = 42L;
    private Vec3i start;
    private Vec3i end;
    private int innerRadius;
    private int outerRadius;
    private int height;
    private byte type;
    private short fluidLevel;
    private byte fluidType;
    public static boolean tileCalcOn = true;
    public static boolean columnCalcOn = true;

    public WallInfluencer(Vec3i start, Vec3i end, int height, int innerRadius, int outerRadius) {
        this(start, end, height, innerRadius, outerRadius, 0, 0, 0);
    }

    public WallInfluencer(Vec3i start, Vec3i end, int height, int innerRadius, int outerRadius, int type, int fluidLevel, int fluidType) {
        if (Objects.equals(start, end)) {
            throw new IllegalArgumentException("Start and end cannot be the same point");
        }
        this.start = start;
        this.end = end;
        this.height = height;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.type = (byte)type;
        this.fluidLevel = (short)fluidLevel;
        this.fluidType = (byte)fluidType;
    }

    public Vec3i getStart() {
        return this.start;
    }

    public Vec3i getEnd() {
        return this.end;
    }

    public int getHeight() {
        return this.height;
    }

    public int getInnerRadius() {
        return this.innerRadius;
    }

    public int getOuterRadius() {
        return this.outerRadius;
    }

    @Override
    public Vec3d getCenter() {
        return this.end.toVec3d().subtractLocal(this.start).multLocal(0.5).addLocal(0.0, (double)this.height * 0.5, 0.0);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public byte getFluidType() {
        return this.fluidType;
    }

    @Override
    public Vec3i getMin() {
        Vec3i min = this.start.clone().minLocal(this.end);
        return min.subtract(this.outerRadius, 0, this.outerRadius);
    }

    @Override
    public Vec3i getMax() {
        Vec3i max = this.start.clone().maxLocal(this.end);
        return max.add(this.outerRadius, 0, this.outerRadius);
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.outerRadius - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.outerRadius - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.outerRadius - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.outerRadius - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    private double clamp(double v, double min, double max) {
        if (v <= min) {
            return min;
        }
        if (v >= max) {
            return max;
        }
        return v;
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    @Override
    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        Vec3i min = this.start.clone().minLocal(this.end);
        Vec3i max = this.start.clone().maxLocal(this.end);
        min.subtractLocal(this.outerRadius, 0, this.outerRadius);
        max.addLocal(this.outerRadius, 0, this.outerRadius);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public boolean morph(Tile tile, Random rand) {
        if (!tileCalcOn) {
            return false;
        }
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.outerRadius - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.outerRadius - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.outerRadius - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.outerRadius - origin.z;
        xMin = Math.max(xMin, 0);
        zMin = Math.max(zMin, 0);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        Vec3d dirXz = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double lengthXz = dirXz.length();
        dirXz.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        Vec3d dir = this.end.subtract(this.start).toVec3d();
        double length = dir.length();
        dir.normalizeLocal();
        int outerRadiusSq = this.outerRadius * this.outerRadius;
        boolean changed = false;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                double xRel = (double)(x * spread) - localStart.x;
                double zRel = (double)(z * spread) - localStart.z;
                double project = dirXz.dot(xRel, 0.0, zRel);
                project = this.clamp(project, 0.0, lengthXz);
                Vec3d p = localStart.add(dirXz.mult(project));
                p.y = 0.0;
                double dSq = p.distanceSq((double)(x * spread), 0.0, (double)(z * spread));
                if (dSq > (double)outerRadiusSq) continue;
                double yExtent = 0.0;
                if ((double)outerRadiusSq > dSq) {
                    yExtent = Math.sqrt((double)outerRadiusSq - dSq);
                }
                p.set(localStart).addLocal(dir.mult(project * length / lengthXz));
                int yMin = Math.max(0, (int)Math.floor(p.y - yExtent) + 1);
                int yMax = Math.min(640, (int)Math.floor(p.y + yExtent + (double)this.height) + 1);
                short elevation = terrain.getElevation(x, z);
                if (elevation > yMax || elevation < yMin) continue;
                terrain.setElevation(x, z, (short)yMin);
                changed = true;
            }
        }
        return true;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        if (!columnCalcOn) {
            return false;
        }
        Vec3i origin = colData.getColumnId().getWorld(null);
        log.info("-------------------------------morph(" + origin + ")");
        Vec3d dirXz = this.end.subtract(this.start).toVec3d();
        dirXz.y = 0.0;
        double lengthXz = dirXz.length();
        dirXz.normalizeLocal();
        Vec3d dir = this.end.subtract(this.start).toVec3d();
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        int yMin = Math.min(this.start.y, this.end.y) - this.outerRadius;
        int yMax = Math.max(this.start.y, this.end.y) + this.outerRadius;
        int marker = BlockTypeIndex.findType((BlockName)new BlockName("magic-white", "mini2"), (int)1);
        int marker2 = BlockTypeIndex.findType((BlockName)new BlockName("glass", "cube"), (int)1);
        int marker3 = BlockTypeIndex.findType((BlockName)new BlockName("magic-red", "mini2"), (int)1);
        double outerRadiusSq = this.outerRadius * this.outerRadius;
        double innerRadiusSq = this.innerRadius * this.innerRadius;
        LeafData[] leafs = colData.getLeafs();
        FluidData[] fluid = colData.getFluid();
        int topFluid = FluidUtils.setLevel((int)this.fluidType, (int)6);
        int fullFluid = FluidUtils.setLevel((int)this.fluidType, (int)8);
        boolean changed = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                double project;
                double xRel = (double)x - localStart.x;
                double zRel = (double)z - localStart.z;
                boolean debug = false;
                if (debug) {
                    log.info("x:" + x + "  z:" + z + "  xRel:" + xRel + "  zRel:" + zRel);
                }
                if ((project = dirXz.dot(xRel, 0.0, zRel)) < 0.0 || project > lengthXz) {
                    project = this.clamp(project, 0.0, lengthXz);
                }
                Vec3d p = localStart.add(dirXz.mult(project));
                p.y = 0.0;
                double dSq = p.distanceSq((double)x, 0.0, (double)z);
                if (debug) {
                    log.info("p:" + p + "  project:" + project);
                    log.info("  dSq:" + dSq + "  outerRadiusSq:" + outerRadiusSq);
                }
                if (dSq > outerRadiusSq) continue;
                project = project * length / lengthXz;
                p.set(localStart).addLocal(dir.mult(project));
                double yOriginal = p.y;
                yMin = (int)this.clamp(p.y - (double)this.outerRadius, 1.0, 640.0);
                yMax = (int)this.clamp(p.y + (double)this.outerRadius + (double)this.height, 1.0, 640.0) + 1;
                for (int y = yMin; y <= yMax; ++y) {
                    if (debug) {
                        log.info("p 3D:" + p + "  yMin:" + yMin + " yMax:" + yMax);
                    }
                    p.y = (double)y < yOriginal ? yOriginal : ((double)y > yOriginal + (double)this.height ? yOriginal + (double)this.height : (double)y);
                    dSq = p.distanceSq((double)x, (double)y, (double)z);
                    if (debug) {
                        log.info("  dSq:" + dSq);
                    }
                    if (dSq > outerRadiusSq) continue;
                    if (dSq >= innerRadiusSq) {
                        double chance = (dSq - innerRadiusSq) / (outerRadiusSq - innerRadiusSq);
                        chance *= chance;
                        double dice = rand.nextDouble();
                        if (dice < chance) continue;
                    }
                    int layer = y / 32;
                    LeafData leaf = colData.getLeafs()[layer];
                    int j = y % 32;
                    leaf.setCell(x, j, z, 0);
                    if (y < this.fluidLevel) {
                        if (y == this.fluidLevel - 1) {
                            fluid[layer].setCell(x, j, z, topFluid);
                        } else {
                            fluid[layer].setCell(x, j, z, fullFluid);
                        }
                    }
                    changed = true;
                }
            }
        }
        return changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[start:" + this.start + ", end:" + this.end + ", outerRadius:" + this.outerRadius + ", innerRadius:" + this.innerRadius + "]";
    }
}

