/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.ethereal.net.FrameState;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.mathd.util.FixedIntRange;
import com.simsilica.mathd.util.IntRange;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SentState {
    public long created = System.nanoTime();
    public int messageId;
    public IntRange[] acked;
    public List<FrameState> frames;

    public SentState(int messageId, IntRange[] acked, List<FrameState> frames) {
        this.messageId = messageId;
        this.acked = acked;
        this.frames = frames;
    }

    public boolean isBefore(SentState state) {
        return this.isBefore(state.messageId);
    }

    public boolean isBefore(int compare) {
        if (Math.abs(this.messageId - compare) > 32000) {
            return true;
        }
        return this.messageId < compare;
    }

    public int getEstimatedHeaderSize() {
        int result = 0;
        result += 8;
        return result += this.acked == null ? 0 : this.acked.length * 48;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SentState fromByteArray(int sequenceId, byte[] buffer, ObjectStateProtocol protocol) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(buffer);
        try (BitInputStream in = new BitInputStream(bIn);){
            ArrayList<FrameState> frames = new ArrayList<FrameState>();
            int size = in.readBits(8);
            IntRange[] acks = new IntRange[size];
            for (int i = 0; i < size; ++i) {
                int min = in.readBits(32);
                int length = in.readBits(16);
                acks[i] = new FixedIntRange(min, min + length - 1);
            }
            while (in.readBits(1) == 1) {
                FrameState frame = new FrameState();
                frame.readBits(in, protocol);
                frames.add(frame);
            }
            SentState sentState = new SentState(sequenceId, acks, frames);
            return sentState;
        }
    }

    public static byte[] toByteArray(SentState state, ObjectStateProtocol protocol) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BitOutputStream out = new BitOutputStream(bOut);
        out.writeBits(state.acked.length, 8);
        for (IntRange range : state.acked) {
            out.writeBits(range.getMinValue(), 32);
            out.writeBits(range.getLength(), 16);
        }
        for (FrameState frame : state.frames) {
            out.writeBits(1, 1);
            frame.writeBits(out, protocol);
        }
        out.writeBits(0, 1);
        out.close();
        return bOut.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.asList(this.acked).toString());
        return "SentState[messageId=" + this.messageId + ", created=" + this.created + ", acked=[" + sb + "], frames=" + this.frames + "]";
    }
}

